/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.messages;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class DebugEnablePathfindingMessage
extends AbstractColonyServerMessage {
    private int id;
    private boolean enable = false;

    public DebugEnablePathfindingMessage() {
    }

    public DebugEnablePathfindingMessage(ICitizenDataView citizen, boolean enable) {
        super(citizen.getColony());
        this.id = citizen.getId();
        this.enable = enable;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.enable = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.enable);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null || !DebugPlayerManager.hasDebugEnabled((Player)player)) {
            return;
        }
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.id);
        if (citizen == null || !citizen.getEntity().isPresent()) {
            return;
        }
        if (this.enable) {
            PathfindingUtils.trackingMap.put(player.m_20148_(), citizen.getUUID());
        } else {
            PathfindingUtils.trackingMap.remove(player.m_20148_());
        }
    }
}

