/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.service;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.IDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingDeliveryman;
import com.minecolonies.core.colony.interactionhandling.PosBasedInteraction;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobDeliveryman;
import com.minecolonies.core.colony.requestsystem.requests.StandardRequests;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import com.minecolonies.core.tileentities.TileEntityRack;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkDeliveryman
extends AbstractEntityAIInteract<JobDeliveryman, BuildingDeliveryman> {
    private static final int MIN_DISTANCE_TO_WAREHOUSE = 5;
    private static final int DECISION_DELAY = 100;
    private static final int PICKUP_DELAY = 5;
    private static final int SLOT_HAND = 0;
    private static final int PRIORITY_FORCING_DUMP = 10;
    private static final VisibleCitizenStatus DELIVERING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/delivery.png"), "com.minecolonies.gui.visiblestatus.delivery");
    public static final String RENDER_META_BACKPACK = "backpack";
    private int currentSlot = 0;
    private List<ItemStorage> alreadyKept = new ArrayList<ItemStorage>();

    public EntityAIWorkDeliveryman(@NotNull JobDeliveryman deliveryman) {
        super(deliveryman);
        super.registerTargets(new AITarget<Object>(AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::checkIfExecute, this::decide, 100), new AITarget<Object>(AIWorkerState.PREPARE_DELIVERY, this::prepareDelivery, 5), new AITarget<Object>(AIWorkerState.DELIVERY, this::deliver, 5), new AITarget<Object>(AIWorkerState.PICKUP, this::pickup, 5), new AITarget<Object>(AIWorkerState.DUMPING, this::dump, 20));
        this.worker.m_21553_(true);
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.worker.getInventoryCitizen().isEmpty() ? "" : RENDER_META_BACKPACK);
    }

    @Override
    public Class<BuildingDeliveryman> getExpectedBuildingClass() {
        return BuildingDeliveryman.class;
    }

    private IAIState pickup() {
        this.setDelay(20);
        IRequest<IDeliverymanRequestable> currentTask = ((JobDeliveryman)this.job).getCurrentTask();
        if (!(currentTask instanceof StandardRequests.PickupRequest)) {
            return AIWorkerState.START_WORKING;
        }
        if (this.cannotHoldMoreItems()) {
            this.alreadyKept = new ArrayList<ItemStorage>();
            this.currentSlot = 0;
            return AIWorkerState.DUMPING;
        }
        this.worker.getCitizenData().setVisibleStatus(DELIVERING);
        BlockPos pickupTarget = currentTask.getRequester().getLocation().getInDimensionLocation();
        IBuilding pickupBuilding = ((BuildingDeliveryman)this.building).getColony().getBuildingManager().getBuilding(pickupTarget);
        if (pickupBuilding == null) {
            ((JobDeliveryman)this.job).finishRequest(false);
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToBuilding(pickupBuilding)) {
            return AIWorkerState.PICKUP;
        }
        if (this.pickupFromBuilding(pickupBuilding)) {
            this.alreadyKept = new ArrayList<ItemStorage>();
            this.currentSlot = 0;
            ((JobDeliveryman)this.job).finishRequest(true);
            StatsUtil.trackStatByName((IBuilding)this.building, "pickups_made", pickupBuilding.getBuildingDisplayName(), 1);
            if (currentTask.getRequest().getPriority() >= 10) {
                return AIWorkerState.DUMPING;
            }
            return AIWorkerState.START_WORKING;
        }
        if (InventoryUtils.openSlotCount((IItemHandler)this.worker.getInventoryCitizen()) <= 0L) {
            this.alreadyKept = new ArrayList<ItemStorage>();
            this.currentSlot = 0;
            return AIWorkerState.DUMPING;
        }
        this.setDelay(5);
        ++this.currentSlot;
        return AIWorkerState.PICKUP;
    }

    private boolean pickupFromBuilding(@NotNull IBuilding targetBuilding) {
        if (this.cannotHoldMoreItems() || InventoryUtils.openSlotCount((IItemHandler)this.worker.getInventoryCitizen()) <= 0L) {
            return false;
        }
        IItemHandler handler = (IItemHandler)targetBuilding.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
        if (handler == null) {
            return false;
        }
        if (this.currentSlot >= handler.getSlots()) {
            return true;
        }
        ItemStack stack = handler.getStackInSlot(this.currentSlot);
        while (stack.m_41619_()) {
            ++this.currentSlot;
            if (this.currentSlot >= handler.getSlots()) {
                return true;
            }
            stack = handler.getStackInSlot(this.currentSlot);
        }
        int amount = EntityAIWorkDeliveryman.workerRequiresItem(targetBuilding, stack, this.alreadyKept);
        if (amount <= 0) {
            return false;
        }
        if (ItemStackUtils.isEmpty(handler.getStackInSlot(this.currentSlot))) {
            return false;
        }
        ItemStack activeStack = handler.extractItem(this.currentSlot, amount, false);
        InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(activeStack, (IItemHandler)this.worker.getInventoryCitizen());
        targetBuilding.markDirty();
        this.worker.decreaseSaturationForContinuousAction();
        this.worker.getCitizenExperienceHandler().addExperience(0.01);
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, 0);
        return false;
    }

    private boolean cannotHoldMoreItems() {
        if (((BuildingDeliveryman)this.building).getBuildingLevel() >= ((BuildingDeliveryman)this.building).getMaxBuildingLevel()) {
            return false;
        }
        return (double)InventoryUtils.getAmountOfStacksInItemHandler((IItemHandler)this.worker.getInventoryCitizen()) >= Math.pow(2.0, (double)((BuildingDeliveryman)this.building).getBuildingLevel() - 1.0) + 1.0;
    }

    public static int workerRequiresItem(IBuilding building, ItemStack stack, List<ItemStorage> localAlreadyKept) {
        return building.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, false);
    }

    private IAIState dump() {
        @Nullable IWareHouse warehouse = this.getAndCheckWareHouse();
        if (warehouse == null) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToBuilding(warehouse)) {
            this.setDelay(20);
            return AIWorkerState.DUMPING;
        }
        warehouse.getTileEntity().dumpInventoryIntoWareHouse(this.worker.getInventoryCitizen());
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, 0);
        return AIWorkerState.START_WORKING;
    }

    @Nullable
    private IWareHouse getAndCheckWareHouse() {
        return ((JobDeliveryman)this.job).findWareHouse();
    }

    private IAIState deliver() {
        IRequest<IDeliverymanRequestable> currentTask = ((JobDeliveryman)this.job).getCurrentTask();
        if (!(currentTask instanceof StandardRequests.DeliveryRequest)) {
            return AIWorkerState.DUMPING;
        }
        this.worker.getCitizenData().setVisibleStatus(DELIVERING);
        ILocation targetBuildingLocation = ((Delivery)currentTask.getRequest()).getTarget();
        if (!targetBuildingLocation.isReachableFromLocation(this.worker.getLocation())) {
            Log.getLogger().info(this.worker.getCitizenColonyHandler().getColonyOrRegister().getName() + ": " + String.valueOf(this.worker.m_7755_()) + ": Can't inter dimension yet: ");
            return AIWorkerState.START_WORKING;
        }
        IBuilding targetBuilding = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(targetBuildingLocation.getInDimensionLocation());
        if (targetBuilding == null) {
            ((JobDeliveryman)this.job).finishRequest(true);
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToBuilding(targetBuilding)) {
            this.setDelay(20);
            return AIWorkerState.DELIVERY;
        }
        boolean success = true;
        boolean extracted = false;
        InventoryCitizen workerInventory = this.worker.getInventoryCitizen();
        List itemsToDeliver = ((JobDeliveryman)this.job).getTaskListWithSameDestination(currentTask).stream().map(r -> new ItemStorage(((Delivery)r.getRequest()).getStack())).collect(Collectors.toList());
        for (int i = 0; i < workerInventory.getSlots(); ++i) {
            if (workerInventory.getStackInSlot(i).m_41619_() || !itemsToDeliver.contains(new ItemStorage(workerInventory.getStackInSlot(i)))) continue;
            ItemStack stack = workerInventory.extractItem(i, Integer.MAX_VALUE, false);
            int count = stack.m_41613_();
            if (ItemStackUtils.isEmpty(stack)) continue;
            extracted = true;
            ItemStack insertionResultStack = targetBuilding instanceof AbstractBuilding ? InventoryUtils.forceItemStackToItemHandler((IItemHandler)targetBuilding.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElseGet(null), stack, targetBuilding::isItemStackInRequest) : InventoryUtils.forceItemStackToItemHandler((IItemHandler)targetBuilding.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElseGet(null), stack, itemStack -> true);
            if (!ItemStackUtils.isEmpty(insertionResultStack)) {
                if (ItemStack.m_41728_((ItemStack)insertionResultStack, (ItemStack)stack) && this.worker.getCitizenData() != null) {
                    success = false;
                    if (targetBuilding.hasModule(WorkerBuildingModule.class)) {
                        this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((Component)Component.m_237110_((String)"com.minecolonies.coremod.job.deliveryman.namedworkerchestfull", (Object[])new Object[]{((WorkerBuildingModule)targetBuilding.getFirstModuleOccurance(WorkerBuildingModule.class)).getFirstCitizen().getName()}), ChatPriority.IMPORTANT, (Component)Component.m_237115_((String)"com.minecolonies.coremod.job.deliveryman.workerchestfull"), targetBuilding.getID()));
                    } else {
                        this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((Component)Component.m_237110_((String)"com.minecolonies.coremod.job.deliveryman.workerchestfull", (Object[])new Object[]{Component.m_237113_((String)(" :" + targetBuilding.getSchematicName()))}), ChatPriority.IMPORTANT, (Component)Component.m_237115_((String)"com.minecolonies.coremod.job.deliveryman.workerchestfull"), targetBuildingLocation.getInDimensionLocation()));
                    }
                }
                workerInventory.insertItem(i, insertionResultStack, false);
            }
            this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().incrementBy("items_delivered", count - insertionResultStack.m_41613_(), this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
            StatsUtil.trackStatByName((IBuilding)this.building, "deliveries_made", targetBuilding.getBuildingDisplayName(), 1);
        }
        if (!extracted) {
            this.worker.decreaseSaturationForContinuousAction();
            CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, 0);
            ((JobDeliveryman)this.job).finishRequest(false);
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenExperienceHandler().addExperience(1.5);
        this.worker.decreaseSaturationForContinuousAction();
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, 0);
        ((JobDeliveryman)this.job).finishRequest(true);
        return success ? AIWorkerState.START_WORKING : AIWorkerState.DUMPING;
    }

    private IAIState prepareDelivery() {
        IRequest<IDeliverymanRequestable> currentTask = ((JobDeliveryman)this.job).getCurrentTask();
        if (!(currentTask instanceof StandardRequests.DeliveryRequest)) {
            return AIWorkerState.START_WORKING;
        }
        List<IRequest<? extends Delivery>> taskList = ((JobDeliveryman)this.job).getTaskListWithSameDestination(currentTask);
        ArrayList<ItemStack> alreadyInInv = new ArrayList<ItemStack>();
        IRequest<? extends Delivery> nextPickUp = null;
        int parallelDeliveryCount = 0;
        for (IRequest<? extends Delivery> task : taskList) {
            ++parallelDeliveryCount;
            int totalCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((Delivery)task.getRequest()).getStack(), itemStack));
            int hasCount = 0;
            for (ItemStack stack : alreadyInInv) {
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, task.getRequest().getStack()).booleanValue()) continue;
                hasCount += stack.m_41613_();
            }
            if (totalCount < hasCount + task.getRequest().getStack().m_41613_()) {
                nextPickUp = task;
                break;
            }
            alreadyInInv.add(task.getRequest().getStack());
        }
        if (nextPickUp == null || parallelDeliveryCount > 1 + this.getSecondarySkillLevel() / 5) {
            return AIWorkerState.DELIVERY;
        }
        ILocation location = ((Delivery)nextPickUp.getRequest()).getStart();
        if (!location.isReachableFromLocation(this.worker.getLocation())) {
            ((JobDeliveryman)this.job).finishRequest(false);
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToSafePos(location.getInDimensionLocation())) {
            return AIWorkerState.PREPARE_DELIVERY;
        }
        if (this.getInventory().isFull()) {
            return AIWorkerState.DUMPING;
        }
        BlockEntity tileEntity = this.world.m_7702_(location.getInDimensionLocation());
        ((JobDeliveryman)this.job).addConcurrentDelivery((IToken<?>)nextPickUp.getId());
        if (this.gatherIfInTileEntity(tileEntity, nextPickUp.getRequest().getStack())) {
            return AIWorkerState.PREPARE_DELIVERY;
        }
        if (parallelDeliveryCount > 1) {
            ((JobDeliveryman)this.job).removeConcurrentDelivery((IToken<?>)nextPickUp.getId());
            return AIWorkerState.DELIVERY;
        }
        ((JobDeliveryman)this.job).finishRequest(false);
        ((JobDeliveryman)this.job).removeConcurrentDelivery((IToken<?>)nextPickUp.getId());
        return AIWorkerState.START_WORKING;
    }

    public boolean gatherIfInTileEntity(BlockEntity entity, ItemStack is) {
        IItemHandler handler;
        if (ItemStackUtils.isEmpty(is)) {
            return false;
        }
        if ((entity instanceof TileEntityColonyBuilding && InventoryUtils.hasBuildingEnoughElseCount(((TileEntityColonyBuilding)entity).getBuilding(), new ItemStorage(is), is.m_41613_()) >= is.m_41613_() || entity instanceof TileEntityRack && ((TileEntityRack)entity).getCount(new ItemStorage(is)) >= is.m_41613_()) && (handler = (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).resolve().orElse(null)) != null) {
            return InventoryUtils.transferItemStackIntoNextFreeSlotFromItemHandler(handler, stack -> !ItemStackUtils.isEmpty(stack) && ItemStackUtils.compareItemStacksIgnoreStackSize(is, stack, true, true), is.m_41613_(), (IItemHandler)this.worker.getInventoryCitizen());
        }
        return false;
    }

    private IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        IRequest<IDeliverymanRequestable> currentTask = ((JobDeliveryman)this.job).getCurrentTask();
        if (currentTask == null) {
            if (!this.walkToBuilding(this.getAndCheckWareHouse())) {
                this.setDelay(20);
                return AIWorkerState.START_WORKING;
            }
            if (!this.worker.getInventoryCitizen().isEmpty()) {
                return AIWorkerState.DUMPING;
            }
            return AIWorkerState.START_WORKING;
        }
        if (currentTask instanceof StandardRequests.DeliveryRequest) {
            if (!this.worker.getInventoryCitizen().isEmpty()) {
                return AIWorkerState.DUMPING;
            }
            return AIWorkerState.PREPARE_DELIVERY;
        }
        return AIWorkerState.PICKUP;
    }

    private boolean checkIfExecute() {
        IWareHouse wareHouse = this.getAndCheckWareHouse();
        if (wareHouse != null) {
            this.worker.getCitizenData().setWorking(true);
            return wareHouse.getTileEntity() != null;
        }
        this.worker.getCitizenData().setWorking(false);
        if (this.worker.getCitizenData() != null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.job.deliveryman.nowarehouse"), ChatPriority.BLOCKING));
        }
        return false;
    }
}

