/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs.aitasks;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.events.raid.HordeRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class RaiderWalkAI
implements IStateAI {
    private final AbstractEntityMinecoloniesRaider raider;
    private BlockPos targetBlock = null;
    private long walkTimer = 0L;
    private IBuilding walkInBuilding = null;

    public RaiderWalkAI(AbstractEntityMinecoloniesRaider raider, ITickRateStateMachine<IState> stateMachine) {
        this.raider = raider;
        stateMachine.addTransition(new TickingTransition<IState>(CombatAIStates.NO_TARGET, this::walk, () -> null, 80));
    }

    private boolean walk() {
        if (this.raider.getColony() != null) {
            IColonyEvent event = this.raider.getColony().getEventManager().getEventByID(this.raider.getEventID());
            if (event == null) {
                return false;
            }
            if (event.getStatus() == EventStatus.PREPARING && event instanceof HordeRaidEvent) {
                this.walkToCampFire();
                return false;
            }
            this.raider.setTempEnvDamageImmunity(false);
            if (this.targetBlock == null || this.raider.f_19853_.m_46467_() > this.walkTimer) {
                BlockPos moveToPos;
                this.targetBlock = this.raider.getColony().getRaiderManager().getRandomBuilding();
                this.walkTimer = this.raider.f_19853_.m_46467_() + 4800L;
                List<BlockPos> wayPoints = ((IColonyRaidEvent)event).getWayPoints();
                EntityNavigationUtils.walkToPos(this.raider, moveToPos, 4, false, !(moveToPos = ShipBasedRaiderUtils.chooseWaypointFor(wayPoints, this.raider.m_20183_(), this.targetBlock)).equals((Object)this.targetBlock) && moveToPos.m_123333_((Vec3i)wayPoints.get(0)) > 50 ? 1.8 : 1.1);
                this.walkInBuilding = null;
            } else if (this.walkInBuilding != null) {
                if (EntityNavigationUtils.walkToRandomPosWithin(this.raider, 10, 0.7, this.walkInBuilding.getCorners()) && this.raider.m_217043_().m_188500_() < 0.25) {
                    this.walkInBuilding = null;
                    this.targetBlock = null;
                }
                if (this.raider.getNavigation().getPathResult() != null) {
                    ((AbstractPathJob)this.raider.getNavigation().getPathResult().getJob()).getPathingOptions().withCanEnterDoors(true).withToggleCost(0.0).withNonLadderClimbableCost(0.0);
                }
            } else if (this.raider.m_20183_().m_123331_((Vec3i)this.targetBlock) < 25.0) {
                this.walkTimer = this.raider.f_19853_.m_46467_() + 600L;
                this.walkInBuilding = this.raider.getColony().getBuildingManager().getBuilding(this.targetBlock);
            } else if (this.raider.getNavigation().m_26571_()) {
                List<BlockPos> wayPoints = ((IColonyRaidEvent)event).getWayPoints();
                BlockPos moveToPos = ShipBasedRaiderUtils.chooseWaypointFor(wayPoints, this.raider.m_20183_(), this.targetBlock);
                if (moveToPos.equals((Object)BlockPos.f_121853_)) {
                    Log.getLogger().warn("Raider trying to path to zero position, target pos:" + String.valueOf(this.targetBlock) + " Waypoints:");
                    for (BlockPos pos : wayPoints) {
                        Log.getLogger().warn(pos.m_123344_());
                    }
                }
                EntityNavigationUtils.walkToPos(this.raider, moveToPos, 7, true, !moveToPos.equals((Object)this.targetBlock) && moveToPos.m_123333_((Vec3i)wayPoints.get(0)) > 50 ? 1.8 : 1.1);
            }
        }
        return false;
    }

    private void walkToCampFire() {
        if (this.raider.f_19853_.m_46467_() - this.walkTimer < 0L) {
            return;
        }
        BlockPos campFire = ((HordeRaidEvent)this.raider.getColony().getEventManager().getEventByID(this.raider.getEventID())).getRandomCampfire();
        if (campFire == null) {
            return;
        }
        this.walkTimer = this.raider.f_19853_.m_46467_() + (long)this.raider.f_19853_.f_46441_.m_188503_(1000);
        EntityNavigationUtils.walkToRandomPosAround(this.raider, campFire, 10, 0.7);
    }
}

