/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.BuildingResourcesModule;
import com.minecolonies.core.colony.buildings.modules.SettingsModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.interactionhandling.SimpleNotificationInteraction;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.network.messages.server.PlayerAssistantBuildRequestMessage;
import com.minecolonies.core.placementhandlers.SolidPlaceholderPlacementHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ItemAssistantHammer
extends AbstractItemMinecolonies {
    private static final String TAG_LAST_POS = "lastPos";
    private int reach = 1;

    public ItemAssistantHammer(String id, Item.Properties properties, int reach) {
        super(id, properties);
        this.reach = reach;
    }

    public void useOnBlock(Player player, BlockPos interactPos) {
        Level level = player.m_9236_();
        IColonyView view = IColonyManager.getInstance().getColonyView(level, interactPos);
        if (view == null || level == null || !view.getPermissions().hasPermission(player, Action.PLACE_BLOCKS)) {
            return;
        }
        boolean unclaimed = true;
        for (IWorkOrder iWorkOrder : view.getWorkOrders()) {
            if (!iWorkOrder.isClaimed() || iWorkOrder.getBoundingBox() == null || !iWorkOrder.getBoundingBox().m_82400_(2.0).m_82390_(Vec3.m_82528_((Vec3i)interactPos))) continue;
            unclaimed = false;
            if (iWorkOrder.getBlueprint() == null) {
                iWorkOrder.loadBlueprint(player.f_19853_, b -> {});
                return;
            }
            ArrayList<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>(PlacementHandlers.handlers);
            SolidPlaceholderPlacementHandler solidPlaceHolderHandler = new SolidPlaceholderPlacementHandler();
            solidPlaceHolderHandler.setReplacement(view.getBuilding(iWorkOrder.getClaimedBy()).getModuleView(BuildingModules.BUILDER_SETTINGS).getSetting(BuildingMiner.FILL_BLOCK).getValue().m_40614_().m_49966_());
            handlers.add(0, solidPlaceHolderHandler);
            BuildAttemptResult buildAttemptResult = this.tryBuildingBlockNearby(player, view, iWorkOrder, interactPos, handlers);
            if (!buildAttemptResult.areBlocksToBuildNearby() || buildAttemptResult.didTryBuilding()) break;
            player.m_5661_((Component)Component.m_237115_((String)"item.minecolonies.assistanthammer.noitems"), true);
            break;
        }
        if (unclaimed) {
            player.m_5661_((Component)Component.m_237115_((String)"item.minecolonies.assistanthammer.onlyactive"), true);
        }
    }

    public void placeBlock(Player player, IColony colony, IWorkOrder workOrder, BlockPos interactPos) {
        if (workOrder.isClaimed()) {
            BuildingProgressStage stage = workOrder.getStage();
            if (stage == BuildingProgressStage.CLEAR || stage == BuildingProgressStage.CLEAR_NON_SOLIDS) {
                player.m_5661_((Component)Component.m_237115_((String)"item.minecolonies.assistanthammer.notcleared"), true);
                player.f_36095_.m_182423_();
                return;
            }
            if (workOrder.getBlueprint() == null) {
                workOrder.loadBlueprint(player.m_9236_(), b -> {});
                player.m_5661_((Component)Component.m_237115_((String)"item.minecolonies.assistanthammer.notloaded"), true);
                player.f_36095_.m_182423_();
                return;
            }
            ArrayList<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>(PlacementHandlers.handlers);
            SolidPlaceholderPlacementHandler solidPlaceHolderHandler = new SolidPlaceholderPlacementHandler();
            solidPlaceHolderHandler.setReplacement(((SettingsModule)colony.getBuildingManager().getBuilding(workOrder.getClaimedBy()).getModule(BuildingModules.BUILDER_SETTINGS)).getSetting(BuildingMiner.FILL_BLOCK).getValue().m_40614_().m_49966_());
            handlers.add(0, solidPlaceHolderHandler);
            BuildAttemptResult buildAttemptResult = this.tryBuildingBlockNearby(player, colony, workOrder, interactPos, handlers);
            if (buildAttemptResult.areBlocksToBuildNearby() && !buildAttemptResult.didTryBuilding()) {
                player.m_5661_((Component)Component.m_237115_((String)"item.minecolonies.assistanthammer.noitems"), true);
                player.f_36095_.m_182423_();
            }
            if (buildAttemptResult.areBlocksToBuildNearby() && buildAttemptResult.didTryBuilding() && !player.m_7500_()) {
                player.m_21205_().m_41622_(player.m_21205_().m_41720_().damageItem(player.m_21205_(), 1, (LivingEntity)player, s -> {}), (LivingEntity)player, s -> {});
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            BlockPos interactPos = context.m_8083_().m_121945_(context.m_43719_());
            this.useOnBlock(context.m_43723_(), interactPos);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            BlockPos interactPos = BlockPos.m_274446_((Position)player.m_146892_().m_82549_(player.m_20154_().m_82542_(3.0, 3.0, 3.0)));
            this.useOnBlock(player, interactPos);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21205_());
    }

    @NotNull
    private BuildAttemptResult tryBuildingBlockNearby(Player player, IColony colony, IWorkOrder workOrder, BlockPos interactPos, List<IPlacementHandler> handlers) {
        BlockPos.MutableBlockPos workPos = new BlockPos.MutableBlockPos();
        boolean areBlocksToBuildNearby = false;
        player.m_36335_().m_41524_((Item)this, 5);
        for (int currentDistance = 0; currentDistance <= this.reach; ++currentDistance) {
            for (int x = -currentDistance; x <= currentDistance; ++x) {
                for (int y = -currentDistance; y <= currentDistance; ++y) {
                    for (int z = -currentDistance; z <= currentDistance; ++z) {
                        IBuilding building;
                        int distanceSq = x * x + y * y + z * z;
                        if (distanceSq > currentDistance * currentDistance) continue;
                        workPos.m_122178_(x + interactPos.m_123341_(), y + interactPos.m_123342_(), z + interactPos.m_123343_());
                        BlockState levelState = player.m_9236_().m_8055_((BlockPos)workPos);
                        BlockInfo blockInfo = (BlockInfo)workOrder.getBlueprint().getBlockInfoAsMap().get(workPos.m_121996_((Vec3i)workOrder.getLocation()).m_121955_((Vec3i)workOrder.getBlueprint().getPrimaryBlockOffset()));
                        if (blockInfo == null || blockInfo.getState() == null || blockInfo.getState().m_60734_() == levelState.m_60734_() || !levelState.m_60795_() && levelState.m_60819_().m_76178_() || blockInfo.getState().m_60734_() == ModBlocks.blockSubstitution.get() || blockInfo.getState().m_60734_() == ModBlocks.blockFluidSubstitution.get() || blockInfo.getState().m_60734_() == ModBlocks.blockTagSubstitution.get()) continue;
                        ArrayList<ItemStack> requiredItem = new ArrayList<ItemStack>();
                        IPlacementHandler foundHandler = null;
                        for (IPlacementHandler iPlacementHandler : handlers) {
                            if (!iPlacementHandler.canHandle(player.m_9236_(), BlockPos.f_121853_, blockInfo.getState())) continue;
                            List itemList = iPlacementHandler.getRequiredItems(player.m_9236_(), (BlockPos)workPos, blockInfo.getState(), blockInfo.getTileEntityData(), false);
                            requiredItem.addAll(itemList);
                            foundHandler = iPlacementHandler;
                            break;
                        }
                        if (foundHandler == null) {
                            requiredItem.add(BlockUtils.getItemStackFromBlockState((BlockState)blockInfo.getState()));
                        }
                        if (requiredItem.size() != 1) continue;
                        areBlocksToBuildNearby = true;
                        boolean hasItems = true;
                        if (!player.m_7500_()) {
                            for (ItemStack required : requiredItem) {
                                boolean found = false;
                                for (ItemStack stack : player.m_150109_().f_35974_) {
                                    if (!ItemStackUtils.compareItemStacksIgnoreStackSize(required, stack).booleanValue()) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                hasItems = false;
                            }
                        }
                        if (!hasItems) continue;
                        IPlacementHandler.ActionProcessingResult actionProcessingResult = foundHandler.handle(colony.getWorld(), (BlockPos)workPos, blockInfo.getState(), blockInfo.getTileEntityData(), false, workOrder.getLocation(), new PlacementSettings(workOrder.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(workOrder.getRotation())));
                        if (actionProcessingResult == IPlacementHandler.ActionProcessingResult.DENY) continue;
                        if (!colony.getWorld().m_5776_() && (building = colony.getBuildingManager().getBuilding(workOrder.getLocation())) != null) {
                            building.registerBlockPosition(blockInfo.getState(), (BlockPos)workPos, colony.getWorld());
                        }
                        if (!player.m_7500_()) {
                            InventoryUtils.removeStacksFromItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), requiredItem);
                        }
                        if (colony.getWorld().f_46443_) {
                            Network.getNetwork().sendToServer(new PlayerAssistantBuildRequestMessage(colony, workOrder.getID(), interactPos));
                        } else {
                            IBuilding buildingBuilder;
                            building = colony.getBuildingManager().getBuilding(workOrder.getClaimedBy());
                            for (ItemStack stack : requiredItem) {
                                ((BuildingResourcesModule)building.getModule(BuildingModules.BUILDING_RESOURCES)).reduceNeededResource(stack, 1);
                            }
                            if (ColonyConstants.rand.nextInt(20) == 0 && (buildingBuilder = colony.getBuildingManager().getBuilding(workOrder.getClaimedBy())) != null) {
                                ((WorkerBuildingModule)buildingBuilder.getModule(BuildingModules.BUILDER_WORK)).getAssignedCitizen().forEach(citizen -> citizen.triggerInteraction(new SimpleNotificationInteraction((Component)Component.m_237115_((String)"item.minecolonies.assistanthammer.happybuilder"), ChatPriority.CHITCHAT)));
                            }
                        }
                        for (int i = 0; i < 50; ++i) {
                            player.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockInfo.getState()), (double)((float)workPos.m_123341_() + 0.5f) - 0.5 + (double)ColonyConstants.rand.nextFloat(1.5f), (double)((float)workPos.m_123342_() + 0.5f) - 0.5 + (double)ColonyConstants.rand.nextFloat(1.5f), (double)((float)workPos.m_123343_() + 0.5f) - 0.5 + (double)ColonyConstants.rand.nextFloat(1.5f), ColonyConstants.rand.nextGaussian() * 5.0, ColonyConstants.rand.nextGaussian() * 5.0, ColonyConstants.rand.nextGaussian() * 5.0);
                        }
                        if (player.m_9236_().m_5776_() && ColonyConstants.rand.nextInt(5) == 0) {
                            player.m_9236_().m_5594_(player, (BlockPos)workPos, SoundEvents.f_11744_, SoundSource.BLOCKS, (0.75f + ColonyConstants.rand.nextFloat(0.5f)) * 2.0f, 0.9f + ColonyConstants.rand.nextFloat(0.2f));
                        }
                        player.m_9236_().m_5594_(player, (BlockPos)workPos, blockInfo.getState().m_60827_().m_56777_(), SoundSource.BLOCKS, blockInfo.getState().m_60827_().m_56773_() * (0.75f + ColonyConstants.rand.nextFloat(0.5f)) * 2.0f, blockInfo.getState().m_60827_().m_56774_() * (0.9f + ColonyConstants.rand.nextFloat(0.2f)));
                        return new BuildAttemptResult(true, true);
                    }
                }
            }
        }
        return new BuildAttemptResult(areBlocksToBuildNearby, false);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltipList, TooltipFlag flag) {
        tooltipList.add((Component)Component.m_237110_((String)"item.minecolonies.assistanthammer.reach", (Object[])new Object[]{this.reach}).m_130940_(ChatFormatting.BLUE));
        tooltipList.add((Component)Component.m_237115_((String)"item.minecolonies.assistanthammer.desc").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
    }

    private record BuildAttemptResult(boolean areBlocksToBuildNearby, boolean didTryBuilding) {
    }
}

