/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintTagUtils;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.ISupplyItem;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.WindowSupplies;
import com.minecolonies.core.client.gui.WindowSupplyStory;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyCampDeployer
extends AbstractItemMinecolonies
implements ISupplyItem {
    public ItemSupplyCampDeployer(Item.Properties properties) {
        super("supplycampdeployer", properties.m_41487_(1));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!ctx.m_43722_().m_41784_().m_128441_("randkey")) {
            ctx.m_43722_().m_41783_().m_128356_("randkey", ctx.m_8083_().m_121878_());
        }
        if (ctx.m_43725_().f_46443_) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(ctx.m_43725_())) {
                MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(ctx.m_43723_());
                return InteractionResult.FAIL;
            }
            this.placeSupplyCamp(ctx.m_8083_().m_5484_(ctx.m_8125_(), 10).m_7494_(), ctx.m_43723_().m_6350_(), ctx.m_43722_(), ctx.m_43724_());
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (!stack.m_41784_().m_128441_("randkey")) {
            stack.m_41783_().m_128356_("randkey", playerIn.m_20183_().m_121878_());
        }
        if (worldIn.f_46443_) {
            if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(worldIn)) {
                MessageUtils.format("com.minecolonies.coremod.dimension.no", new Object[0]).sendTo(playerIn);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
            this.placeSupplyCamp(null, playerIn.m_6350_(), stack, hand);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    private void placeSupplyCamp(@Nullable BlockPos pos, @NotNull Direction direction, ItemStack itemInHand, InteractionHand hand) {
        if (!itemInHand.m_41784_().m_128441_("sawstory")) {
            new WindowSupplyStory(pos, "supplycamp", itemInHand, hand).open();
            return;
        }
        if (pos == null) {
            new WindowSupplies(pos, "supplycamp").open();
            return;
        }
        new WindowSupplies(pos, "supplycamp").open();
    }

    public static boolean canCampBePlaced(@NotNull Level world, @NotNull BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer) {
        if (((Boolean)MineColonies.getConfig().getServer().noSupplyPlacementRestrictions.get()).booleanValue()) {
            return true;
        }
        Blueprint blueprint = RenderingCache.getOrCreateBlueprintPreviewData((String)"supplies").getBlueprint();
        if (blueprint == null) {
            return false;
        }
        BlockPos zeroPos = pos.m_121996_((Vec3i)blueprint.getPrimaryBlockOffset());
        int sizeX = blueprint.getSizeX();
        int sizeZ = blueprint.getSizeZ();
        int groundHeight = BlueprintTagUtils.getNumberOfGroundLevels((Blueprint)blueprint, (int)1) - 1;
        int groundLevel = zeroPos.m_123342_() + groundHeight;
        ArrayList<PlacementError> needsAirAbove = new ArrayList<PlacementError>();
        ArrayList<PlacementError> needsSolidBelow = new ArrayList<PlacementError>();
        for (int z = 0; z < sizeZ; ++z) {
            for (int x = 0; x < sizeX; ++x) {
                BlockPos worldPos = new BlockPos(zeroPos.m_123341_() + x, groundLevel, zeroPos.m_123343_() + z);
                if (blueprint.m_8055_(new BlockPos(x, groundHeight, z)).m_60734_() != ModBlocks.blockSubstitution.get()) {
                    ItemSupplyCampDeployer.checkIfSolidAndNotInColony(world, worldPos, needsSolidBelow, placer);
                }
                if (!BlockUtils.isAnySolid((BlockState)world.m_8055_(worldPos.m_7494_()))) continue;
                needsAirAbove.add(new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, worldPos.m_7494_()));
            }
        }
        if ((double)needsAirAbove.size() > (double)(sizeX * sizeZ) * 0.3333333333333333 || (double)needsSolidBelow.size() > (double)(sizeX * sizeZ) * 0.3333333333333333) {
            placementErrorList.addAll(needsAirAbove);
            placementErrorList.addAll(needsSolidBelow);
            return false;
        }
        return true;
    }

    private static void checkIfSolidAndNotInColony(Level world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, Player placer) {
        boolean isSolid = BlockUtils.isAnySolid((BlockState)world.m_8055_(pos));
        boolean notInAnyColony = ItemSupplyCampDeployer.hasPlacePermission(world, pos, placer);
        if (!isSolid) {
            placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.NOT_SOLID, pos));
        }
        if (!notInAnyColony) {
            placementErrorList.add(new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos));
        }
    }

    private static boolean hasPlacePermission(Level world, BlockPos pos, Player placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

