/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.ChunkCapData;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.util.ChunkClientDataHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChunkRangeCapabilityMessage
implements IMessage {
    private final List<ChunkCapData> caps = new ArrayList<ChunkCapData>();

    public UpdateChunkRangeCapabilityMessage() {
    }

    public UpdateChunkRangeCapabilityMessage(@NotNull Level world, int xC, int zC, int range, boolean checkLoaded) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                LevelChunk chunk;
                IColonyTagCapability cap;
                int chunkX = xC + x;
                int chunkZ = zC + z;
                if (checkLoaded && !WorldUtil.isEntityChunkLoaded((LevelAccessor)world, chunkX, chunkZ) || (cap = (IColonyTagCapability)(chunk = world.m_6325_(chunkX, chunkZ)).getCapability(IColony.CLOSE_COLONY_CAP, null).orElseGet(null)) == null) continue;
                this.caps.add(new ChunkCapData(chunkX, chunkZ, cap.getOwningColony(), cap.getStaticClaimColonies(), cap.getAllClaimingBuildings()));
            }
        }
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.caps.add(ChunkCapData.fromBytes(buf));
        }
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.caps.size());
        for (ChunkCapData c : this.caps) {
            c.toBytes(buf);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        for (ChunkCapData data : this.caps) {
            if (!WorldUtil.isChunkLoaded((LevelAccessor)world, new ChunkPos(data.x, data.z))) {
                ChunkClientDataHelper.addCapData(data);
                continue;
            }
            LevelChunk chunk = world.m_6325_(data.x, data.z);
            ChunkClientDataHelper.applyCap(data, chunk);
        }
    }
}

