/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildingextensions.registry.BuildingExtensionDataManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewBuildingExtensionsUpdateMessage
implements IMessage {
    private int colonyId;
    private ResourceKey<Level> dimension;
    private Map<IBuildingExtension, IBuildingExtension> extensions;

    public ColonyViewBuildingExtensionsUpdateMessage() {
    }

    public ColonyViewBuildingExtensionsUpdateMessage(@NotNull IColony colony, @NotNull Collection<IBuildingExtension> extensions) {
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.extensions = new HashMap<IBuildingExtension, IBuildingExtension>();
        extensions.forEach(extension -> this.extensions.put((IBuildingExtension)extension, (IBuildingExtension)extension));
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeInt(this.extensions.size());
        for (IBuildingExtension extension : this.extensions.keySet()) {
            FriendlyByteBuf buffer = BuildingExtensionDataManager.extensionToBuffer(extension);
            buf.writeInt(buffer.readableBytes());
            buf.writeBytes((ByteBuf)buffer);
        }
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.extensions = new HashMap<IBuildingExtension, IBuildingExtension>();
        int extensionCount = buf.readInt();
        for (int i = 0; i < extensionCount; ++i) {
            int readableBytes = buf.readInt();
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer((int)readableBytes));
            buf.readBytes((ByteBuf)data, readableBytes);
            IBuildingExtension extension = BuildingExtensionDataManager.bufferToExtension(data);
            this.extensions.put(extension, extension);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyView view = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (view != null) {
            HashSet<IBuildingExtension> extensions = new HashSet<IBuildingExtension>();
            view.getBuildingExtensions(extension -> true).forEach(existingExtension -> {
                if (this.extensions.containsKey(existingExtension)) {
                    FriendlyByteBuf copyBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    this.extensions.get(existingExtension).serialize(copyBuffer);
                    existingExtension.deserialize(copyBuffer);
                    extensions.add((IBuildingExtension)existingExtension);
                }
            });
            extensions.addAll(this.extensions.keySet());
            view.handleColonyBuildingExtensionViewUpdateMessage(extensions);
        } else {
            Log.getLogger().error("Colony view does not exist for ID #{}", (Object)this.colonyId);
        }
    }
}

