/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.colony.ColonyView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenBuildingUIMessage
implements IMessage {
    private int colonyId;
    private BlockPos buildingId;
    private ResourceKey<Level> dimension;

    public OpenBuildingUIMessage() {
    }

    public OpenBuildingUIMessage(@NotNull IBuilding building) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.dimension = building.getColony().getDimension();
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = buf.m_130135_();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.m_130064_(this.buildingId);
        buf.m_130070_(this.dimension.m_135782_().toString());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ColonyView colonyView;
        Object object = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (object instanceof ColonyView && (object = (colonyView = (ColonyView)object).getBuilding(this.buildingId)) instanceof AbstractBuildingView) {
            AbstractBuildingView buildingView = (AbstractBuildingView)object;
            buildingView.openGui(false);
        }
    }
}

