/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.network.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ClickGuiButtonTriggerMessage
implements IMessage {
    private String buttonId;
    private String resource;

    public ClickGuiButtonTriggerMessage() {
    }

    public ClickGuiButtonTriggerMessage(String buttonId, String resource) {
        this.resource = resource;
        this.buttonId = buttonId;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.resource);
        buf.m_130070_(this.buttonId);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.resource = buf.m_130136_(Short.MAX_VALUE);
        this.buttonId = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        if (player != null) {
            AdvancementTriggers.CLICK_GUI_BUTTON.trigger(player, this.buttonId, this.resource);
        }
    }
}

