/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.Colony;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class PickupBlockMessage
implements IMessage {
    BlockPos pos;

    public PickupBlockMessage() {
    }

    public PickupBlockMessage(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer sender = ctxIn.getSender();
        Level world = ctxIn.getSender().f_19853_;
        if (sender == null) {
            return;
        }
        if (IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos) instanceof Colony) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)world.m_8055_(this.pos).m_60734_(), 1);
        CompoundTag compoundNBT = new CompoundTag();
        stack.m_41751_(compoundNBT);
        if (InventoryUtils.addItemStackToProvider((ICapabilityProvider)sender, stack)) {
            world.m_46961_(this.pos, false);
        } else {
            MessageUtils.format("com.minecolonies.coremod.playerinvfull", new Object[0]).sendTo(new Player[]{sender});
        }
    }
}

