/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.eventbus.events.colony.ColonyFlagChangedModEvent;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ColonyFlagChangeMessage
extends AbstractColonyServerMessage {
    private ListTag patterns;

    public ColonyFlagChangeMessage() {
    }

    public ColonyFlagChangeMessage(IColony colony, ListTag patternList) {
        super(colony);
        this.patterns = patternList;
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        colony.setColonyFlag(this.patterns);
        IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyFlagChangedModEvent(colony));
    }

    @Override
    protected void toBytesOverride(FriendlyByteBuf buf) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Patterns", (Tag)this.patterns);
        buf.m_130079_(nbt);
    }

    @Override
    protected void fromBytesOverride(FriendlyByteBuf buf) {
        CompoundTag nbt = buf.m_130260_();
        if (nbt != null) {
            this.patterns = nbt.m_128437_("Patterns", 10);
        }
    }
}

