/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.connections.ConnectionEvent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class TriggerConnectionEventMessage
extends AbstractColonyServerMessage {
    private ConnectionEvent connectionEventData;
    private int targetColonyId;

    public TriggerConnectionEventMessage() {
    }

    public TriggerConnectionEventMessage(IColony colony, ConnectionEvent coreConnectionEventData, int targetColonyId) {
        super(colony);
        this.connectionEventData = coreConnectionEventData;
        this.targetColonyId = targetColonyId;
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        if (colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS)) {
            IColony targetColony = IColonyManager.getInstance().getColonyByDimension(this.targetColonyId, colony.getDimension());
            if (targetColony == null) {
                Log.getLogger().error("Tried to trigger connection event at null colony: {}", (Object)this.targetColonyId);
                return;
            }
            targetColony.getConnectionManager().triggerConnectionEvent(this.connectionEventData);
        }
    }

    @Override
    protected void toBytesOverride(FriendlyByteBuf buf) {
        this.connectionEventData.serializeByteBuf(buf);
        buf.writeInt(this.targetColonyId);
    }

    @Override
    protected void fromBytesOverride(FriendlyByteBuf buf) {
        this.connectionEventData = ConnectionEvent.deserializeByteBuf(buf);
        this.targetColonyId = buf.readInt();
    }
}

