/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IQuestDeliveryObjective;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.quests.objectives.DialogueObjectiveTemplateTemplate;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class DeliveryObjectiveTemplateTemplate
extends DialogueObjectiveTemplateTemplate
implements IQuestDeliveryObjective {
    private final ItemStack item;
    private final int quantity;
    private final int nextObjective;
    private final String nbtMode;
    private IDialogueObjectiveTemplate.DialogueElement readyDialogueElement;
    private IDialogueObjectiveTemplate.DialogueElement waitingDialogueElement;

    public DeliveryObjectiveTemplateTemplate(int target, ItemStack item, int quantity, int nextObjective, List<Integer> rewards, String nbtMode) {
        super(target, null, rewards);
        this.item = item;
        this.quantity = quantity;
        this.nextObjective = nextObjective;
        this.nbtMode = nbtMode;
        this.buildDialogueTrees();
    }

    private void buildDialogueTrees() {
        MutableComponent ready = Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.delivery.ready", (Object[])new Object[]{this.item.m_41611_()});
        IDialogueObjectiveTemplate.AnswerElement ready1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.delivery.ready.give"), new IQuestDialogueAnswer.NextObjectiveDialogueAnswer(this.nextObjective));
        IDialogueObjectiveTemplate.AnswerElement ready2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.delivery.ready.later"), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        this.readyDialogueElement = new IDialogueObjectiveTemplate.DialogueElement((Component)ready, List.of(ready1, ready2));
        MutableComponent waiting = Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.delivery.waiting", (Object[])new Object[]{this.item.m_41611_()});
        IDialogueObjectiveTemplate.AnswerElement waiting1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.later"), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement waiting2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.delivery.waiting.cancel"), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        this.waitingDialogueElement = new IDialogueObjectiveTemplate.DialogueElement((Component)waiting, List.of(waiting1, waiting2));
    }

    public static IQuestObjectiveTemplate createObjective(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        int quantity = details.get("qty").getAsInt();
        ItemStack item = new ItemStack((ItemLike)((Holder)ForgeRegistries.ITEMS.getHolder(new ResourceLocation(details.get("item").getAsString())).get()).get());
        if (details.has("nbt")) {
            try {
                item.m_41751_(TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)details, (String)"nbt")));
            }
            catch (CommandSyntaxException e) {
                Log.getLogger().error("Unable to load itemstack nbt from json!");
                throw new RuntimeException(e);
            }
        }
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        String nbtMode = details.has("nbt-mode") ? details.get("nbt-mode").getAsString() : "";
        return new DeliveryObjectiveTemplateTemplate(target, item, quantity, nextObj, DeliveryObjectiveTemplateTemplate.parseRewards(jsonObject), nbtMode);
    }

    @Override
    public boolean hasItem(Player player, IQuestInstance colonyQuest) {
        return InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, this.item, !this.nbtMode.equals("any"), !this.nbtMode.equals("any"))) >= this.quantity;
    }

    @Override
    public boolean tryDiscountItem(Player player, IQuestInstance colonyQuest) {
        return InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), this.item, this.quantity, this.nbtMode.equals("any"), this.nbtMode.equals("any"));
    }

    @Override
    public IDialogueObjectiveTemplate.DialogueElement getDialogueTree() {
        return this.waitingDialogueElement;
    }

    @Override
    public IDialogueObjectiveTemplate.DialogueElement getReadyDialogueTree() {
        return this.readyDialogueElement;
    }

    @Override
    public Component getProgressText(IQuestInstance quest, Style style) {
        return Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.delivery.progress", (Object[])new Object[]{0, this.quantity, this.item.m_41611_().m_6879_().m_6270_(style)});
    }
}

