/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.event.QuestObjectiveEventHandler;
import com.minecolonies.core.quests.objectives.DialogueObjectiveTemplateTemplate;
import com.minecolonies.core.quests.objectives.IResearchObjectiveTemplate;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ResearchObjectiveTemplate
extends DialogueObjectiveTemplateTemplate
implements IResearchObjectiveTemplate {
    private final ResourceLocation researchId;
    private final int nextObjective;

    public ResearchObjectiveTemplate(int target, ResourceLocation researchId, int nextObjective, List<Integer> rewards) {
        super(target, ResearchObjectiveTemplate.buildDialogueTree(researchId), rewards);
        this.researchId = researchId;
        this.nextObjective = nextObjective;
    }

    @NotNull
    private static IDialogueObjectiveTemplate.DialogueElement buildDialogueTree(ResourceLocation researchId) {
        IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(researchId);
        MutableComponent text = Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.research", (Object[])new Object[]{MutableComponent.m_237204_((ComponentContents)research.getName())});
        IDialogueObjectiveTemplate.AnswerElement answer1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.later"), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement answer2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.cancel"), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        return new IDialogueObjectiveTemplate.DialogueElement((Component)text, List.of(answer1, answer2));
    }

    public static IQuestObjectiveTemplate createObjective(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        ResourceLocation researchId = new ResourceLocation(details.get("type").getAsString());
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        return new ResearchObjectiveTemplate(target, researchId, nextObj, ResearchObjectiveTemplate.parseRewards(jsonObject));
    }

    @Override
    public IObjectiveInstance startObjective(IQuestInstance colonyQuest) {
        super.startObjective(colonyQuest);
        IColony iColony = colonyQuest.getColony();
        if (iColony instanceof Colony) {
            Colony colony = (Colony)iColony;
            if (colony.getResearchManager().getResearchTree().isComplete(this.researchId)) {
                return colonyQuest.advanceObjective(colonyQuest.getColony().getWorld().m_46003_(colonyQuest.getAssignedPlayer()), this.nextObjective);
            }
            QuestObjectiveEventHandler.trackResearch(this.researchId, colonyQuest);
        }
        return null;
    }

    private boolean advanceIfFinished(IQuestInstance colonyQuest) {
        Colony colony;
        IColony iColony = colonyQuest.getColony();
        if (iColony instanceof Colony && (colony = (Colony)iColony).getResearchManager().getResearchTree().isComplete(this.researchId)) {
            this.cleanupListener(colonyQuest);
            colonyQuest.advanceObjective(colonyQuest.getColony().getWorld().m_46003_(colonyQuest.getAssignedPlayer()), this.nextObjective);
            return true;
        }
        return false;
    }

    private void cleanupListener(IQuestInstance colonyQuest) {
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.stopTrackingResearch(this.researchId, colonyQuest);
        }
    }

    @Override
    public Component getProgressText(IQuestInstance quest, Style style) {
        IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.researchId);
        return Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.research.progress", (Object[])new Object[]{MutableComponent.m_237204_((ComponentContents)research.getName())});
    }

    @Override
    public void onCancellation(IQuestInstance colonyQuest) {
        this.cleanupListener(colonyQuest);
    }

    @Override
    public void onWorldLoad(IQuestInstance colonyQuest) {
        super.onWorldLoad(colonyQuest);
        IColony iColony = colonyQuest.getColony();
        if (iColony instanceof Colony) {
            Colony colony = (Colony)iColony;
            if (!this.advanceIfFinished(colonyQuest)) {
                QuestObjectiveEventHandler.trackResearch(this.researchId, colonyQuest);
            }
        }
    }

    @Override
    public void onResearchCompletion(IQuestInstance colonyQuest) {
        this.cleanupListener(colonyQuest);
        colonyQuest.advanceObjective(colonyQuest.getColony().getWorld().m_46003_(colonyQuest.getAssignedPlayer()), this.nextObjective);
    }
}

