/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityColonyFlag
extends BlockEntity {
    private ListTag patterns = new ListTag();
    public int colonyId = -1;

    public TileEntityColonyFlag(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.COLONY_FLAG.get(), pos, state);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Patterns", (Tag)this.patterns);
        compound.m_128405_("colony", this.colonyId);
    }

    public void m_142466_(CompoundTag compound) {
        IColony colony;
        super.m_142466_(compound);
        this.patterns = compound.m_128437_("Patterns", 10);
        this.colonyId = compound.m_128451_("colony");
        if (this.colonyId == -1 && this.m_58898_() && (colony = IColonyManager.getInstance().getIColony(this.m_58904_(), this.f_58858_)) != null) {
            this.colonyId = colony.getID();
            this.m_6596_();
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
    }

    public List<Pair<Holder<BannerPattern>, DyeColor>> getPatterns() {
        IColonyView colony;
        if (this.f_58857_ != null && this.f_58857_.m_46472_() != null && (colony = IColonyManager.getInstance().getColonyView(this.colonyId, (ResourceKey<Level>)this.f_58857_.m_46472_())) != null && this.patterns != colony.getColonyFlag()) {
            this.patterns = colony.getColonyFlag();
            this.m_6596_();
        }
        List pattern = BannerBlockEntity.m_58484_((DyeColor)DyeColor.WHITE, (ListTag)this.patterns);
        pattern.remove(0);
        return pattern;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItemClient() {
        ItemStack itemstack = new ItemStack(ModBlocks.blockColonyBanner);
        List<Pair<Holder<BannerPattern>, DyeColor>> list = this.getPatterns();
        ListTag nbt = new ListTag();
        for (Pair<Holder<BannerPattern>, DyeColor> pair : list) {
            CompoundTag pairNBT = new CompoundTag();
            pairNBT.m_128359_("Pattern", ((BannerPattern)((Holder)pair.getFirst()).get()).m_58579_());
            pairNBT.m_128405_("Color", ((DyeColor)pair.getSecond()).m_41060_());
            nbt.add((Object)pairNBT);
        }
        if (!nbt.isEmpty()) {
            itemstack.m_41698_("BlockEntityTag").m_128365_("Patterns", (Tag)nbt);
        }
        return itemstack;
    }

    public ItemStack getItemServer() {
        return new ItemStack((ItemLike)ModItems.flagBanner);
    }
}

