/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.structurize.api.util.ItemStorage;
import com.ldtteam.structurize.blocks.schematic.BlockSolidSubstitution;
import com.ldtteam.structurize.blocks.schematic.BlockSubstitution;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.core.util.DomumOrnamentumUtils;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class SchemAnalyzerUtil {
    public static int getBlockTier(Block block) {
        if (block == null) {
            return -1;
        }
        if (block.m_49966_().m_204336_(ModTags.tier6blocks)) {
            return 6;
        }
        if (block.m_49966_().m_204336_(ModTags.tier5blocks)) {
            return 5;
        }
        if (block.m_49966_().m_204336_(ModTags.tier4blocks)) {
            return 4;
        }
        if (block.m_49966_().m_204336_(ModTags.tier3blocks)) {
            return 3;
        }
        if (block.m_49966_().m_204336_(ModTags.tier2blocks)) {
            return 2;
        }
        if (block.m_49966_().m_204336_(ModTags.tier1blocks)) {
            return 1;
        }
        return 0;
    }

    public static double getScoreFor(Block block) {
        double score = Math.pow(SchemAnalyzerUtil.getBlockTier(block) + 1, 3.0);
        BlockState state = block.m_49966_();
        if (state.m_204336_(BlockTags.f_13106_)) {
            score = Math.min(27.0, score);
        } else if (state.m_204336_(BlockTags.f_13096_) || state.m_204336_(BlockTags.f_13092_) || state.m_204336_(BlockTags.f_13095_) || state.m_204336_(BlockTags.f_13097_) || state.m_204336_(BlockTags.f_13098_) || state.m_204336_(BlockTags.f_13102_) || state.m_204336_(BlockTags.f_13100_)) {
            score = Math.min(27.0, score);
            score *= 0.25;
        } else if (state.m_204336_(BlockTags.f_13090_)) {
            score = Math.min(27.0, score);
            score *= 0.25;
        } else if (state.m_204336_(BlockTags.f_13031_)) {
            score *= 0.5;
        } else if (state.m_204336_(BlockTags.f_13028_)) {
            score *= 6.0;
        } else if (state.m_204336_(Tags.Blocks.STORAGE_BLOCKS)) {
            score *= 9.0;
        } else if (state.m_204336_(BlockTags.f_13033_)) {
            score *= 31.0;
        } else if (state.m_204336_(Tags.Blocks.BOOKSHELVES)) {
            score *= 3.0;
        } else if (state.m_204336_(BlockTags.f_13062_)) {
            score = 8.0;
        }
        return score;
    }

    public static SchematicAnalyzationResult analyzeSchematic(Blueprint blueprint) {
        double complexityScore = 0.0;
        int containedBuildings = 0;
        HashMap<ItemStorage, ItemStorage> blocks = new HashMap<ItemStorage, ItemStorage>();
        for (BlockInfo blockInfo : blueprint.getBlockInfoAsList()) {
            ItemStorage storage;
            if (SchemAnalyzerUtil.isExcludedBlock(blockInfo.getState())) continue;
            Block block = blockInfo.getState().m_60734_();
            double blockComplexity = 0.0;
            if (DomumOrnamentumUtils.isDoBlock(block) && blockInfo.hasTileEntityData()) {
                MaterialTextureData textureData = DomumOrnamentumUtils.getTextureDataFromNBT(blockInfo.getTileEntityData());
                ItemStack result = new ItemStack((ItemLike)block);
                if (textureData != null) {
                    double doComplexity = 0.0;
                    for (Block doBlockPart : textureData.getTexturedComponents().values()) {
                        doComplexity += SchemAnalyzerUtil.getScoreFor(doBlockPart);
                    }
                    blockComplexity = Math.max(2.0, doComplexity / 3.0);
                    result.m_41784_().m_128365_(DomumOrnamentumUtils.DO_NBT_TEXTURE_DATA, (Tag)blockInfo.getTileEntityData().m_128469_(DomumOrnamentumUtils.DO_NBT_TEXTURE_DATA));
                }
                storage = new ItemStorage(result);
            } else {
                blockComplexity = SchemAnalyzerUtil.getScoreFor(block);
                storage = new ItemStorage(block.m_5456_().m_7968_());
            }
            complexityScore += blockComplexity;
            storage.setAmount(0);
            storage.getItemStack().m_41764_((int)Math.max(1.0, blockComplexity));
            ItemStorage contained = (ItemStorage)blocks.get(storage);
            if (contained == null) {
                contained = storage;
                blocks.put(contained, contained);
            }
            contained.setAmount(contained.getAmount() + 1);
            if (!(block instanceof AbstractBlockHut)) continue;
            ++containedBuildings;
        }
        complexityScore += (double)(containedBuildings * 500);
        complexityScore += (double)(blocks.keySet().size() * 40);
        return new SchematicAnalyzationResult((int)(complexityScore += (double)(blueprint.getSizeX() * blueprint.getSizeY() * blueprint.getSizeZ()) / 10.0), blocks.keySet(), containedBuildings, blueprint);
    }

    private static boolean isExcludedBlock(BlockState blockState) {
        return blockState == null || blockState.m_60795_() || blockState.m_60734_() instanceof BlockSubstitution || blockState.m_60734_() instanceof BlockSolidSubstitution;
    }

    public static class SchematicAnalyzationResult {
        public final int costScore;
        public final Set<ItemStorage> differentBlocks;
        public final int containedBuildings;
        public final Blueprint blueprint;

        public SchematicAnalyzationResult(int costScore, Set<ItemStorage> differentBlocks, int containedBuildings, Blueprint blueprint) {
            this.costScore = costScore;
            this.differentBlocks = differentBlocks;
            this.containedBuildings = containedBuildings;
            this.blueprint = blueprint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchematicAnalyzationResult that = (SchematicAnalyzationResult)o;
            return Objects.equals(this.blueprint, that.blueprint);
        }

        public int hashCode() {
            return Objects.hash(this.blueprint);
        }
    }
}

