/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl.condition;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbranks.api.RankCondition;
import java.util.NoSuchElementException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;

public class StatCondition
implements RankCondition {
    public static final int EQUALS = 1;
    public static final int NOT_EQUALS = 2;
    public static final int GREATER = 3;
    public static final int GREATER_OR_EQUAL = 4;
    public static final int LESSER = 5;
    public static final int LESSER_OR_EQUAL = 6;
    private final ResourceLocation statId;
    private final int value;
    private final int valueCheck;
    private final Stat<?> stat;

    public StatCondition(SNBTCompoundTag tag) {
        this.statId = new ResourceLocation(tag.m_128461_("stat"));
        this.stat = BuiltInRegistries.f_256771_.m_6612_(this.statId).map(arg_0 -> ((StatType)Stats.f_12988_).m_12902_(arg_0)).orElseThrow(() -> new NoSuchElementException(String.format("%s does not match any known stat", this.statId)));
        this.value = tag.m_128451_("value");
        switch (tag.m_128461_("value_check")) {
            case "not_equals": 
            case "not": 
            case "!=": {
                this.valueCheck = 2;
                break;
            }
            case "greater": 
            case ">": {
                this.valueCheck = 3;
                break;
            }
            case "greater_or_equal": 
            case ">=": {
                this.valueCheck = 4;
                break;
            }
            case "lesser": 
            case "<": {
                this.valueCheck = 5;
                break;
            }
            case "lesser_or_equal": 
            case "<=": {
                this.valueCheck = 6;
                break;
            }
            default: {
                this.valueCheck = 1;
            }
        }
    }

    @Override
    public String getType() {
        return "stat";
    }

    @Override
    public boolean isRankActive(ServerPlayer player) {
        if (this.stat == null) {
            return false;
        }
        int v = player.m_8951_().m_13015_(this.stat);
        return switch (this.valueCheck) {
            case 2 -> {
                if (v != this.value) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (v > this.value) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (v >= this.value) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (v < this.value) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (v <= this.value) {
                    yield true;
                }
                yield false;
            }
            default -> v == this.value;
        };
    }

    @Override
    public void save(SNBTCompoundTag tag) {
        tag.m_128359_("stat", this.statId.toString());
        tag.m_128405_("value", this.value);
        switch (this.valueCheck) {
            case 2: {
                tag.m_128359_("value_check", "!=");
                break;
            }
            case 3: {
                tag.m_128359_("value_check", ">");
                break;
            }
            case 4: {
                tag.m_128359_("value_check", ">=");
                break;
            }
            case 5: {
                tag.m_128359_("value_check", "<");
                break;
            }
            case 6: {
                tag.m_128359_("value_check", "<=");
                break;
            }
            default: {
                tag.m_128359_("value_check", "==");
            }
        }
    }
}

