/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item.weapons;

import io.redspace.ironsspellbooks.util.TooltipsUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoloaderCrossbow
extends CrossbowItem {
    public static final String LOADING = "Loading";
    public static final String LOADING_TIMESTAMP = "LoadingTimestamp";

    public AutoloaderCrossbow(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player player, InteractionHand pHand) {
        ItemStack itemstack = player.m_21120_(pHand);
        if (AutoloaderCrossbow.m_40932_((ItemStack)itemstack)) {
            AutoloaderCrossbow.m_40887_((Level)pLevel, (LivingEntity)player, (InteractionHand)pHand, (ItemStack)itemstack, (float)AutoloaderCrossbow.m_40945_((ItemStack)itemstack), (float)1.0f);
            AutoloaderCrossbow.m_40884_((ItemStack)itemstack, (boolean)false);
            if (!player.m_6298_(itemstack).m_41619_()) {
                AutoloaderCrossbow.startLoading(player, itemstack);
            } else {
                player.m_5496_(SoundEvents.f_12018_, 0.75f, 1.5f);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (AutoloaderCrossbow.isLoading(itemstack)) {
            if (player.m_6047_()) {
                AutoloaderCrossbow.setLoadingTicks(itemstack, 0);
                AutoloaderCrossbow.setLoading(itemstack, false);
            }
        } else {
            if (!player.m_6298_(itemstack).m_41619_()) {
                AutoloaderCrossbow.startLoading(player, itemstack);
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static void startLoading(Player player, ItemStack itemstack) {
        AutoloaderCrossbow.setLoading(itemstack, true);
        AutoloaderCrossbow.setLoadingTicks(itemstack, 0);
    }

    public void m_6883_(ItemStack itemstack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        AutoloaderCrossbow.handleTicking(itemstack, pLevel, pEntity);
        super.m_6883_(itemstack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        int i = AutoloaderCrossbow.getLoadingTicks(stack);
        AutoloaderCrossbow.handleTicking(stack, entity.f_19853_, (Entity)entity);
        if (i != AutoloaderCrossbow.getLoadingTicks(stack)) {
            ItemStack cloneStack = stack.m_41777_();
            entity.m_32045_(cloneStack);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    protected static void handleTicking(ItemStack itemStack, Level level, @NotNull Entity entity) {
        if (!level.f_46443_ && AutoloaderCrossbow.isLoading(itemStack)) {
            int i = AutoloaderCrossbow.getLoadingTicks(itemStack);
            if (i > AutoloaderCrossbow.m_40939_(itemStack)) {
                SoundSource soundsource;
                AutoloaderCrossbow.setLoading(itemStack, false);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (!AutoloaderCrossbow.m_40932_((ItemStack)itemStack) && AutoloaderCrossbow.m_40859_((LivingEntity)livingEntity, (ItemStack)itemStack)) {
                        AutoloaderCrossbow.m_40884_((ItemStack)itemStack, (boolean)true);
                    }
                }
                SoundSource soundSource = soundsource = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.BLOCKS;
                if (AutoloaderCrossbow.m_40932_((ItemStack)itemStack)) {
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11841_, soundsource, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
                } else {
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12018_, soundsource, 1.0f, 1.7f);
                }
            }
            AutoloaderCrossbow.setLoadingTicks(itemStack, ++i);
        }
    }

    public static int m_40939_(ItemStack pCrossbowStack) {
        return CrossbowItem.m_40939_((ItemStack)pCrossbowStack) * 3;
    }

    public static boolean isLoading(ItemStack pCrossbowStack) {
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_(LOADING);
    }

    public static void setLoading(ItemStack pCrossbowStack, boolean isLoading) {
        pCrossbowStack.m_41784_().m_128379_(LOADING, isLoading);
    }

    public static int getLoadingTicks(ItemStack pCrossbowStack) {
        CompoundTag compoundtag = pCrossbowStack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_(LOADING_TIMESTAMP) : 0;
    }

    public static void setLoadingTicks(ItemStack pCrossbowStack, int timestamp) {
        pCrossbowStack.m_41784_().m_128405_(LOADING_TIMESTAMP, timestamp);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        TooltipsUtils.addShiftTooltip(pTooltip, List.of(Component.m_237115_((String)"item.irons_spellbooks.autoloader_crossbow.desc").m_130940_(ChatFormatting.YELLOW)));
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
    }
}

