/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.client.handler;

import com.blakebr0.cucumber.config.ModConfigs;
import com.blakebr0.cucumber.lib.Tooltips;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class NBTTooltipHandler {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack;
        CompoundTag tag;
        if (!((Boolean)ModConfigs.ENABLE_NBT_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92125_ && (tag = (stack = event.getItemStack()).m_41783_()) != null) {
            List tooltip = event.getToolTip();
            if (Screen.m_96639_()) {
                try {
                    JsonElement text = JsonParser.parseString((String)tag.m_7916_());
                    String json = GSON.toJson(text);
                    for (String line : json.split("\n")) {
                        tooltip.add(Component.m_237113_((String)("\u00a78" + line)));
                    }
                }
                catch (JsonParseException e) {
                    tooltip.add(Tooltips.FAILED_TO_LOAD_NBT.build());
                }
            } else {
                tooltip.add(Tooltips.HOLD_ALT_FOR_NBT.build());
            }
        }
    }
}

