/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.platform;

import corgitaco.corgilib.CorgiLib;
import java.nio.file.Path;
import java.util.Collection;
import java.util.ServiceLoader;

public interface ModPlatform {
    public static final ModPlatform PLATFORM = ModPlatform.load(ModPlatform.class);

    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public Collection<String> getModIDS();

    public Path configDir();

    default public Path modConfigDir() {
        return this.configDir().resolve("corgilib");
    }

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        CorgiLib.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

