/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.network;

import appeng.api.networking.IGrid;
import dev.architectury.networking.NetworkChannel;
import dev.lasm.betterp2p.network.ModNetwork;
import dev.lasm.betterp2p.network.PlayerRequest;
import dev.lasm.betterp2p.network.data.GridServerCache;
import dev.lasm.betterp2p.network.data.MemoryInfo;
import dev.lasm.betterp2p.network.packet.C2SCloseGui;
import dev.lasm.betterp2p.network.packet.C2SCloseGuiKt;
import dev.lasm.betterp2p.network.packet.C2SLinkP2P;
import dev.lasm.betterp2p.network.packet.C2SLinkP2PKt;
import dev.lasm.betterp2p.network.packet.C2SRefreshP2PList;
import dev.lasm.betterp2p.network.packet.C2SRefreshP2PListKt;
import dev.lasm.betterp2p.network.packet.C2SRenameP2P;
import dev.lasm.betterp2p.network.packet.C2SRenameP2PKt;
import dev.lasm.betterp2p.network.packet.C2STypeChange;
import dev.lasm.betterp2p.network.packet.C2STypeChangeKt;
import dev.lasm.betterp2p.network.packet.C2SUnlinkP2P;
import dev.lasm.betterp2p.network.packet.C2SUnlinkP2PKt;
import dev.lasm.betterp2p.network.packet.C2SUpdateMemoryInfo;
import dev.lasm.betterp2p.network.packet.C2SUpdateMemoryInfoKt;
import dev.lasm.betterp2p.network.packet.IMessage;
import dev.lasm.betterp2p.network.packet.S2COpenGui;
import dev.lasm.betterp2p.network.packet.S2COpenGuiKt;
import dev.lasm.betterp2p.network.packet.S2CUpdateP2P;
import dev.lasm.betterp2p.network.packet.S2CUpdateP2PKt;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b2\u0010\u0014J1\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\"\b\b\u0000\u0010\u0003*\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001b\u0010\u0016J\r\u0010\u001c\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u0014R\u001f\u0010\u001f\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R)\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b)\u0010*R#\u0010.\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0+8\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Ldev/lasm/betterp2p/network/ModNetwork;", "", "Ldev/lasm/betterp2p/network/packet/IMessage;", "T", "Lkotlin/Function0;", "factory", "Lkotlin/Function1;", "Lnet/minecraft/network/FriendlyByteBuf;", "decoder", "(Lkotlin/jvm/functions/Function0;)Lkotlin/jvm/functions/Function1;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lappeng/api/networking/IGrid;", "grid", "Ldev/lasm/betterp2p/network/data/MemoryInfo;", "info", "", "initConnection", "(Lnet/minecraft/world/entity/player/Player;Lappeng/api/networking/IGrid;Ldev/lasm/betterp2p/network/data/MemoryInfo;)V", "registerNetwork", "()V", "removeConnection", "(Lnet/minecraft/world/entity/player/Player;)V", "", "type", "requestP2PList", "(Lnet/minecraft/world/entity/player/Player;I)V", "requestP2PUpdate", "stop", "Ldev/architectury/networking/NetworkChannel;", "kotlin.jvm.PlatformType", "channel", "Ldev/architectury/networking/NetworkChannel;", "getChannel", "()Ldev/architectury/networking/NetworkChannel;", "Lkotlin/Function2;", "encoder", "Lkotlin/jvm/functions/Function2;", "getEncoder", "()Lkotlin/jvm/functions/Function2;", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "networkWorker", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "", "Ljava/util/UUID;", "Ldev/lasm/betterp2p/network/PlayerRequest;", "playerState", "Ljava/util/Map;", "getPlayerState", "()Ljava/util/Map;", "<init>", "betterp2p"})
public final class ModNetwork {
    @NotNull
    public static final ModNetwork INSTANCE = new ModNetwork();
    private static final NetworkChannel channel = NetworkChannel.create((ResourceLocation)new ResourceLocation("betterp2p", "networking_channel"));
    @NotNull
    private static final Map<UUID, PlayerRequest> playerState;
    private static ScheduledThreadPoolExecutor networkWorker;
    @NotNull
    private static final Function2<IMessage, FriendlyByteBuf, Unit> encoder;

    private ModNetwork() {
    }

    public final NetworkChannel getChannel() {
        return channel;
    }

    @NotNull
    public final Map<UUID, PlayerRequest> getPlayerState() {
        return playerState;
    }

    @NotNull
    public final Function2<IMessage, FriendlyByteBuf, Unit> getEncoder() {
        return encoder;
    }

    @NotNull
    public final <T extends IMessage> Function1<FriendlyByteBuf, T> decoder(@NotNull Function0<? extends T> factory) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        return new Function1<FriendlyByteBuf, T>(factory){
            final /* synthetic */ Function0<T> $factory;
            {
                this.$factory = $factory;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull FriendlyByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Object object = this.$factory.invoke();
                IMessage it = (IMessage)object;
                boolean bl = false;
                it.fromBytes(buf);
                return (T)((IMessage)object);
            }
        };
    }

    public final void registerNetwork() {
        channel.register(S2COpenGui.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$0(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$2(this.decoder(registerNetwork.1.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$3(S2COpenGuiKt.getClientOpenGuiHandler(), arg_0, arg_1));
        channel.register(S2CUpdateP2P.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$4(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$6(this.decoder(registerNetwork.2.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$7(S2CUpdateP2PKt.getClientUpdateP2PHandler(), arg_0, arg_1));
        channel.register(C2SLinkP2P.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$8(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$10(this.decoder(registerNetwork.3.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$11(C2SLinkP2PKt.getServerLinkP2PHandler(), arg_0, arg_1));
        channel.register(C2SCloseGui.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$12(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$13(this.decoder(registerNetwork.4.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$14(C2SCloseGuiKt.getServerCloseGuiHandler(), arg_0, arg_1));
        channel.register(C2SUpdateMemoryInfo.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$15(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$17(this.decoder(registerNetwork.5.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$18(C2SUpdateMemoryInfoKt.getServerUpdateMemoryInfoHandler(), arg_0, arg_1));
        channel.register(C2SRenameP2P.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$19(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$21(this.decoder(registerNetwork.6.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$22(C2SRenameP2PKt.getServerRenameP2PTunnelHandler(), arg_0, arg_1));
        channel.register(C2SRefreshP2PList.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$23(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$25(this.decoder(registerNetwork.7.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$26(C2SRefreshP2PListKt.getServerRefreshP2PListHandler(), arg_0, arg_1));
        channel.register(C2SUnlinkP2P.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$27(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$29(this.decoder(registerNetwork.8.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$30(C2SUnlinkP2PKt.getServerUnlinkP2PHandler(), arg_0, arg_1));
        channel.register(C2STypeChange.class, (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$31(encoder, arg_0, arg_1), arg_0 -> ModNetwork.registerNetwork$lambda$33(this.decoder(registerNetwork.9.INSTANCE), arg_0), (arg_0, arg_1) -> ModNetwork.registerNetwork$lambda$34(C2STypeChangeKt.getServerTypeChangeHandler(), arg_0, arg_1));
        networkWorker = new ScheduledThreadPoolExecutor(1, ModNetwork::registerNetwork$lambda$35);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestP2PList(@NotNull Player player, int type) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<UUID, PlayerRequest> map = playerState;
        synchronized (map) {
            boolean bl = false;
            PlayerRequest playerRequest = playerState.get(player.m_20148_());
            if (playerRequest == null) {
                return;
            }
            PlayerRequest playerState = playerRequest;
            GridServerCache cache = playerState.getGridCache();
            cache.setType(type);
            if (playerState.getUpdateReady$betterp2p() + 250L < System.currentTimeMillis()) {
                channel.sendToPlayer((ServerPlayer)player, (Object)new S2CUpdateP2P(cache.retrieveP2PList(), true));
                playerState.setUpdateReady$betterp2p(System.currentTimeMillis() + 250L);
            } else if (!playerState.getUpdatePending$betterp2p()) {
                playerState.setUpdatePending$betterp2p(true);
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
                if (scheduledThreadPoolExecutor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
                    scheduledThreadPoolExecutor = null;
                }
                scheduledThreadPoolExecutor.schedule(() -> ModNetwork.requestP2PList$lambda$38$lambda$37(player, cache, playerState), playerState.getUpdateReady$betterp2p() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestP2PUpdate(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<UUID, PlayerRequest> map = playerState;
        synchronized (map) {
            boolean bl = false;
            PlayerRequest playerRequest = playerState.get(player.m_20148_());
            if (playerRequest == null) {
                return;
            }
            PlayerRequest playerState = playerRequest;
            GridServerCache cache = playerState.getGridCache();
            if (playerState.getUpdateReady$betterp2p() + 250L < System.currentTimeMillis()) {
                channel.sendToPlayer((ServerPlayer)player, (Object)new S2CUpdateP2P(cache.getP2PUpdates(), false, 2, null));
                playerState.setUpdateReady$betterp2p(System.currentTimeMillis() + 250L);
            } else if (!playerState.getUpdatePending$betterp2p()) {
                playerState.setUpdatePending$betterp2p(true);
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
                if (scheduledThreadPoolExecutor == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
                    scheduledThreadPoolExecutor = null;
                }
                scheduledThreadPoolExecutor.schedule(() -> ModNetwork.requestP2PUpdate$lambda$41$lambda$40(player, cache, playerState), playerState.getUpdateReady$betterp2p() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void initConnection(@NotNull Player player, @NotNull IGrid grid, @NotNull MemoryInfo info2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        GridServerCache cache = new GridServerCache(grid, player, info2.getType());
        Map<UUID, PlayerRequest> map = playerState;
        UUID uUID = player.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uuid");
        UUID uUID2 = uUID;
        PlayerRequest playerRequest = new PlayerRequest(false, 0L, cache, 3, null);
        map.put(uUID2, playerRequest);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        channel.sendToPlayer((ServerPlayer)player, (Object)new S2COpenGui(cache.retrieveP2PList(), info2));
    }

    public final void removeConnection(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        playerState.remove(player.m_20148_());
    }

    public final void stop() {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = networkWorker;
        if (scheduledThreadPoolExecutor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"networkWorker");
            scheduledThreadPoolExecutor = null;
        }
        scheduledThreadPoolExecutor.shutdown();
    }

    private static final void registerNetwork$lambda$0(Function2 $tmp0, S2COpenGui p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final S2COpenGui registerNetwork$lambda$2(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (S2COpenGui)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$3(Function2 $tmp0, S2COpenGui p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$4(Function2 $tmp0, S2CUpdateP2P p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final S2CUpdateP2P registerNetwork$lambda$6(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (S2CUpdateP2P)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$7(Function2 $tmp0, S2CUpdateP2P p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$8(Function2 $tmp0, C2SLinkP2P p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final C2SLinkP2P registerNetwork$lambda$10(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (C2SLinkP2P)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$11(Function2 $tmp0, C2SLinkP2P p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$12(Function2 $tmp0, C2SCloseGui p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final C2SCloseGui registerNetwork$lambda$13(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (C2SCloseGui)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$14(Function2 $tmp0, C2SCloseGui p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$15(Function2 $tmp0, C2SUpdateMemoryInfo p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final C2SUpdateMemoryInfo registerNetwork$lambda$17(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (C2SUpdateMemoryInfo)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$18(Function2 $tmp0, C2SUpdateMemoryInfo p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$19(Function2 $tmp0, C2SRenameP2P p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final C2SRenameP2P registerNetwork$lambda$21(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (C2SRenameP2P)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$22(Function2 $tmp0, C2SRenameP2P p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$23(Function2 $tmp0, C2SRefreshP2PList p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final C2SRefreshP2PList registerNetwork$lambda$25(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (C2SRefreshP2PList)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$26(Function2 $tmp0, C2SRefreshP2PList p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$27(Function2 $tmp0, C2SUnlinkP2P p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final C2SUnlinkP2P registerNetwork$lambda$29(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (C2SUnlinkP2P)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$30(Function2 $tmp0, C2SUnlinkP2P p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final void registerNetwork$lambda$31(Function2 $tmp0, C2STypeChange p0, FriendlyByteBuf p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final C2STypeChange registerNetwork$lambda$33(Function1 $tmp0, FriendlyByteBuf p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (C2STypeChange)$tmp0.invoke((Object)p0);
    }

    private static final void registerNetwork$lambda$34(Function2 $tmp0, C2STypeChange p0, Supplier p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, (Object)p1);
    }

    private static final Thread registerNetwork$lambda$35(Runnable it) {
        Thread th = new Thread(it);
        th.setName("BetterP2P-NetworkWorker");
        th.setDaemon(true);
        th.setPriority(1);
        return th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void requestP2PList$lambda$38$lambda$37(Player $player, GridServerCache $cache, PlayerRequest $playerState) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$cache, (String)"$cache");
        Intrinsics.checkNotNullParameter((Object)$playerState, (String)"$playerState");
        Map<UUID, PlayerRequest> map = playerState;
        synchronized (map) {
            boolean bl = false;
            channel.sendToPlayer((ServerPlayer)$player, (Object)new S2CUpdateP2P($cache.retrieveP2PList(), true));
            $playerState.setUpdatePending$betterp2p(false);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void requestP2PUpdate$lambda$41$lambda$40(Player $player, GridServerCache $cache, PlayerRequest $playerState) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$cache, (String)"$cache");
        Intrinsics.checkNotNullParameter((Object)$playerState, (String)"$playerState");
        Map<UUID, PlayerRequest> map = playerState;
        synchronized (map) {
            boolean bl = false;
            channel.sendToPlayer((ServerPlayer)$player, (Object)new S2CUpdateP2P($cache.getP2PUpdates(), false, 2, null));
            $playerState.setUpdatePending$betterp2p(false);
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        Map map = Collections.synchronizedMap(new WeakHashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(WeakHashMap())");
        playerState = map;
        encoder = encoder.1.INSTANCE;
    }
}

