/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.network.data;

import appeng.api.networking.IGridNode;
import appeng.me.GridNode;
import appeng.parts.p2p.P2PTunnelPart;
import dev.lasm.betterp2p.network.data.P2PInfo;
import dev.lasm.betterp2p.util.p2p.P2PUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0015\u0010\n\u001a\u00020\u0002*\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/minecraft/network/FriendlyByteBuf;", "buf", "Ldev/lasm/betterp2p/network/data/P2PInfo;", "readP2PInfo", "(Lnet/minecraft/network/FriendlyByteBuf;)Ldev/lasm/betterp2p/network/data/P2PInfo;", "info", "", "writeP2PInfo", "(Lnet/minecraft/network/FriendlyByteBuf;Ldev/lasm/betterp2p/network/data/P2PInfo;)V", "Lappeng/parts/p2p/P2PTunnelPart;", "toInfo", "(Lappeng/parts/p2p/P2PTunnelPart;)Ldev/lasm/betterp2p/network/data/P2PInfo;", "betterp2p"})
public final class P2PInfoKt {
    @Nullable
    public static final P2PInfo readP2PInfo(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        try {
            short freq = buf.readShort();
            BlockPos pos = BlockPos.m_122022_((long)buf.readLong());
            ResourceKey world = buf.m_236801_(Registries.f_256858_);
            Direction facing = Direction.values()[buf.readInt()];
            String name = buf.m_130277_();
            boolean output = buf.readBoolean();
            boolean hasChannel = buf.readBoolean();
            byte channels2 = buf.readByte();
            byte type = buf.readByte();
            Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
            return new P2PInfo(freq, pos, (ResourceKey<Level>)world, facing, name.toString(), output, hasChannel, channels2, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void writeP2PInfo(@NotNull FriendlyByteBuf buf, @NotNull P2PInfo info2) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        buf.writeShort((int)info2.getFrequency());
        buf.writeLong(info2.getPos().m_121878_());
        buf.m_236858_(info2.getDim());
        buf.writeInt(info2.getFacing().ordinal());
        buf.m_130070_(info2.getName());
        buf.writeBoolean(info2.getOutput());
        buf.writeBoolean(info2.getHasChannel());
        buf.writeByte(info2.getChannels());
        buf.writeByte(info2.getType());
    }

    @NotNull
    public static final P2PInfo toInfo(@NotNull P2PTunnelPart<?> $this$toInfo) {
        IGridNode iGridNode;
        Intrinsics.checkNotNullParameter($this$toInfo, (String)"<this>");
        short s = $this$toInfo.getFrequency();
        BlockPos blockPos = $this$toInfo.getBlockEntity().m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockEntity.blockPos");
        Level level = $this$toInfo.getBlockEntity().m_58904_();
        Intrinsics.checkNotNull((Object)level);
        ResourceKey resourceKey = level.m_46472_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"blockEntity.level!!.dimension()");
        Direction direction = $this$toInfo.getSide();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"side");
        Component component = $this$toInfo.m_7770_();
        String string = component != null ? component.getString() : null;
        if (string == null) {
            string = "";
        }
        GridNode gridNode = (iGridNode = $this$toInfo.getExternalFacingNode()) instanceof GridNode ? (GridNode)iGridNode : null;
        return new P2PInfo(s, blockPos, (ResourceKey<Level>)resourceKey, direction, string, $this$toInfo.isOutput(), P2PUtilKt.getHasChannel($this$toInfo), gridNode != null ? gridNode.getUsedChannels() : -1, P2PUtilKt.getTypeIndex($this$toInfo));
    }
}

