/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.LangKey;

@OnlyIn(value=Dist.CLIENT)
public final class CustomToast
implements Toast {
    public static final CustomToast INSTANCE = new CustomToast();
    private static final long DISPLAY_TIME = 5000L;
    private final Component title = LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(new Object[0]);
    @Nullable
    private Pair<ItemStack, ItemStack> combination;
    private Component description;
    private long lastChanged;
    private boolean changed;

    private CustomToast() {
    }

    public Object m_7283_() {
        return this;
    }

    public int m_7828_() {
        return 200;
    }

    public int m_94899_() {
        return 50;
    }

    public void addCombination(ItemStack initial, ItemStack added, Component description) {
        ToastComponent toastHandler = Minecraft.m_91087_().m_91300_();
        CustomToast customToast = (CustomToast)toastHandler.m_94926_(this.getClass(), this.m_7283_());
        if (customToast == null) {
            toastHandler.f_94916_.add(this);
        }
        this.combination = Pair.of((Object)initial, (Object)added);
        this.description = description;
        this.changed = true;
    }

    public Toast.Visibility m_7172_(GuiGraphics guiGraphics, ToastComponent compo, long time) {
        if (this.changed) {
            this.lastChanged = time;
            this.changed = false;
        }
        if (this.combination == null || !(compo.m_94929_().f_91080_ instanceof EffectRenderingInventoryScreen)) {
            return Toast.Visibility.HIDE;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(compo.m_94929_().f_91062_);
        int lineHeight = 9;
        List splits = compo.m_94929_().f_91062_.m_92923_((FormattedText)this.description, this.m_7828_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int y = (compo.m_94929_().m_91268_().m_85446_() - this.m_94899_()) / 2;
        guiGraphics.m_280509_(0, y, this.m_7828_(), y + 22 + lineHeight * splits.size(), -341384);
        guiGraphics.m_280509_(1, y + 1, this.m_7828_(), y + 21 + lineHeight * splits.size(), -14274713);
        guiGraphics.m_280509_(4, y + 2, 20, y + 18, -4144960);
        guiGraphics.m_280509_(48, y + 2, 64, y + 18, -4144960);
        guiGraphics.drawString(font, this.title.getString(), 70.0f, (float)(y + 6), -341384, false);
        float height = y + 20;
        for (FormattedCharSequence split : splits) {
            guiGraphics.drawString(font, split, 4.0f, height, -11141121, false);
            height += (float)lineHeight;
        }
        ItemStack left = (ItemStack)this.combination.getLeft();
        ItemStack right = (ItemStack)this.combination.getRight();
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_(0.0f, (float)y, 0.0f);
        RenderSystem.applyModelViewMatrix();
        guiGraphics.m_280480_(left, 4, 2);
        float scale = 0.8f;
        float revScale = 1.25f;
        guiGraphics.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
        guiGraphics.m_280218_(f_94893_, 40, 2, 234, 20, 20, 20);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BookViewScreen.f_98252_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(BookViewScreen.f_98252_, 25, 8, 23, 192, 23, 13);
        guiGraphics.m_280168_().m_85841_(1.25f, 1.25f, 1.25f);
        posestack.m_252880_(44.0f, 0.0f, 0.0f);
        RenderSystem.applyModelViewMatrix();
        guiGraphics.m_280480_(right, 4, 2);
        posestack.m_85849_();
        return time - this.lastChanged >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

