/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.function.BooleanSupplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModPerks;

public abstract class ItemTablet
extends ItemGraveMagic {
    private static final int MAX_USE_COUNT = 10;

    public ItemTablet(String name, BooleanSupplier supplierBoolean) {
        super(name, supplierBoolean);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.m_246342_(new ItemStack((ItemLike)this));
            toAdd.m_246342_(this.createAncient());
        }
    }

    @Override
    protected int getCastingCooldown() {
        return TimeHelper.tickFromSecond((Integer)SharedConfigTombstone.magic_item.tabletCooldown.get());
    }

    protected int getUseCount(ItemStack stack) {
        if (stack.m_41720_() == this) {
            return Math.min(NBTStackHelper.getInteger(stack, "useCount", 10), 10);
        }
        return 0;
    }

    @Override
    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        if (Helper.RANDOM.nextInt(10) > EntityHelper.getPerkLevelWithBonus(player, ModPerks.rune_inscriber)) {
            int useCount = this.getUseCount(stack);
            if (useCount < 2) {
                stack.m_41774_(1);
                return stack;
            }
            NBTStackHelper.setInteger(stack, "useCount", --useCount);
            int cd = this.getCastingCooldown();
            if (cd > 0) {
                this.setCooldown(player.m_9236_(), stack, cd);
            }
        }
        return stack;
    }

    public ItemStack createAncient() {
        return NBTStackHelper.setBoolean(new ItemStack((ItemLike)this), "ancient", true);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getUseCount(stack) < 10;
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)(1.0 - this.getDurability(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)this.getDurability(stack) * 13.0f);
    }

    private double getDurability(ItemStack stack) {
        return 1.0 - (double)this.getUseCount(stack) / 10.0;
    }
}

