/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.rsinsertexportupgrade.item;

import com.ultramega.rsinsertexportupgrade.container.UpgradeContainerMenu;
import com.ultramega.rsinsertexportupgrade.registry.ModItems;
import com.ultramega.rsinsertexportupgrade.util.UpgradeType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class UpgradeItem
extends Item {
    public static final String NBT_COMPARE = "Compare";
    public static final String NBT_MODE = "Mode";
    public static final String NBT_SELECTED_INVENTORY_SLOTS = "SelectedInventorySlots";
    private final UpgradeType type;

    public UpgradeItem(UpgradeType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public static int getCompare(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_COMPARE) ? stack.m_41783_().m_128451_(NBT_COMPARE) : 1;
    }

    public static void setCompare(ItemStack stack, int compare, int selectedSideButton) {
        UpgradeItem.setNBT(stack, compare, selectedSideButton, NBT_COMPARE);
    }

    public static int getMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_MODE) ? stack.m_41783_().m_128451_(NBT_MODE) : 1;
    }

    public static void setMode(ItemStack stack, int mode, int selectedSideButton) {
        UpgradeItem.setNBT(stack, mode, selectedSideButton, NBT_MODE);
    }

    private static void setNBT(ItemStack stack, int value, int selectedSideButton, String nbt) {
        ListTag tagList;
        CompoundTag tag;
        if (stack.m_41720_() == ModItems.INSERT_UPGRADE.get() || stack.m_41720_() == ModItems.EXPORT_UPGRADE.get()) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            stack.m_41783_().m_128405_(nbt, value);
        } else if (stack.m_41783_().m_128441_("Inventory_2") && (tag = (CompoundTag)(tagList = stack.m_41783_().m_128437_("Inventory_2", 10)).stream().filter(x -> x.toString().contains("Slot:" + selectedSideButton)).findFirst().orElse(null)) != null) {
            if (!tag.m_128441_("tag")) {
                tag.m_128365_("tag", (Tag)new CompoundTag());
            }
            ((CompoundTag)tag.m_128423_("tag")).m_128405_(nbt, value);
        }
    }

    public static int[] getSelectedInventorySlots(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(NBT_SELECTED_INVENTORY_SLOTS) ? stack.m_41783_().m_128465_(NBT_SELECTED_INVENTORY_SLOTS) : new int[36];
    }

    public static void setSelectedInventorySlots(ItemStack stack, int[] selectedInventorySlots, int selectedSideButton) {
        ListTag tagList;
        CompoundTag tag;
        if (stack.m_41720_() == ModItems.INSERT_UPGRADE.get() || stack.m_41720_() == ModItems.EXPORT_UPGRADE.get()) {
            if (!stack.m_41782_()) {
                stack.m_41751_(new CompoundTag());
            }
            stack.m_41783_().m_128385_(NBT_SELECTED_INVENTORY_SLOTS, selectedInventorySlots);
        } else if (stack.m_41783_().m_128441_("Inventory_2") && (tag = (CompoundTag)(tagList = stack.m_41783_().m_128437_("Inventory_2", 10)).stream().filter(x -> x.toString().contains("Slot:" + selectedSideButton)).findFirst().orElse(null)) != null) {
            if (!tag.m_128441_("tag")) {
                tag.m_128365_("tag", (Tag)new CompoundTag());
            }
            ((CompoundTag)tag.m_128423_("tag")).m_128385_(NBT_SELECTED_INVENTORY_SLOTS, selectedInventorySlots);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (player.m_6047_()) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)new ItemStack(this.type == UpgradeType.INSERT ? (ItemLike)ModItems.INSERT_UPGRADE.get() : (ItemLike)ModItems.EXPORT_UPGRADE.get()));
            }
            player.m_5893_(new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return Component.m_237115_((String)("item.rsinsertexportupgrade." + UpgradeItem.this.type.getName() + "_upgrade"));
                }

                public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
                    return new UpgradeContainerMenu(UpgradeItem.this.type, player, inventory.m_36056_(), windowId, -1);
                }
            });
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

