/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrialforegoingsouls.block.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrialforegoingsouls.IndustrialForegoingSouls;
import com.buuz135.industrialforegoingsouls.block_network.DefaultSoulNetworkElement;
import com.buuz135.industrialforegoingsouls.block_network.SoulNetwork;
import com.buuz135.industrialforegoingsouls.client.SculkSoulTankScreenAddon;
import com.buuz135.industrialforegoingsouls.config.ConfigSoulLaserBase;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoulLaserBaseBlockEntity
extends IndustrialMachineTile<SoulLaserBaseBlockEntity>
implements ILaserBase<SoulLaserBaseBlockEntity> {
    @Save
    private final ProgressBarComponent<SoulLaserBaseBlockEntity> work;
    @Save
    private final SidedInventoryComponent<SoulLaserBaseBlockEntity> catalyst;
    @Save
    private int soulAmount = 0;
    private boolean unloaded;

    public SoulLaserBaseBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(IndustrialForegoingSouls.SOUL_LASER_BLOCK, blockPos, blockState);
        this.setShowEnergy(false);
        this.work = new ProgressBarComponent<SoulLaserBaseBlockEntity>(74, 42, 0, ConfigSoulLaserBase.MAX_PROGRESS){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<SoulLaserBaseBlockEntity>(SoulLaserBaseBlockEntity.this.work.getPosX(), SoulLaserBaseBlockEntity.this.work.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.titanium.progressbar.progress").getString() + ChatFormatting.WHITE + new DecimalFormat().format(SoulLaserBaseBlockEntity.this.work.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(SoulLaserBaseBlockEntity.this.work.getMaxProgress()))));
                        return tooltip;
                    }
                });
            }
        }.setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setCanIncrease(oreLaserBaseTile -> true).setProgressIncrease(0).setCanReset(oreLaserBaseTile -> true).setOnStart(() -> {}).setOnFinishWork(this::onWork);
        this.addProgressBar(this.work);
        this.catalyst = (SidedInventoryComponent)new SidedInventoryComponent("lens", 50, 42, 1, 0).setColor(DyeColor.BLUE).setRange(2, 3).setSlotLimit(1);
        this.addInventory((InventoryComponent)this.catalyst);
        this.catalyst.getFacingModes().keySet().forEach(sideness -> this.catalyst.getFacingModes().put(sideness, IFacingComponent.FaceMode.NONE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new SculkSoulTankScreenAddon(100, 20, this));
    }

    public void m_6596_() {
        super.m_6596_();
    }

    private void onWork() {
        LivingEntity first;
        VoxelShape box;
        List entities;
        if (!this.catalyst.getStackInSlot(0).m_41619_() && this.catalyst.getStackInSlot(0).m_41720_().equals(ModuleCore.LASER_LENS[11].get()) && this.soulAmount + ConfigSoulLaserBase.SOULS_PER_OPERATION <= ConfigSoulLaserBase.SOUL_STORAGE_AMOUNT && (entities = this.f_58857_.m_6443_(LivingEntity.class, (box = Shapes.m_83048_((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).m_83216_((double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() - 1), (double)this.f_58858_.m_123343_())).m_83215_(), entity -> entity.m_6095_().equals(EntityType.f_217015_))).size() > 0 && ((first = (LivingEntity)entities.get(0)).m_21223_() > (float)ConfigSoulLaserBase.DAMAGE_PER_OPERATION || ConfigSoulLaserBase.KILL_WARDEN)) {
            first.m_6469_(first.m_269291_().m_269264_(), (float)ConfigSoulLaserBase.DAMAGE_PER_OPERATION);
            this.soulAmount += ConfigSoulLaserBase.SOULS_PER_OPERATION;
            this.syncObject(this.soulAmount);
        }
        int maxProgress = (int)Math.floor((float)ConfigSoulLaserBase.MAX_PROGRESS * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
        this.work.setMaxProgress(maxProgress);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, SoulLaserBaseBlockEntity blockEntity) {
        super.clientTick(level, pos, state, (IndustrialMachineTile)blockEntity);
        VoxelShape box = Shapes.m_83048_((double)-1.0, (double)0.0, (double)-1.0, (double)2.0, (double)3.0, (double)2.0).m_83216_((double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() - 1), (double)this.f_58858_.m_123343_());
        List entities = this.f_58857_.m_45976_(Mob.class, box.m_83215_());
        for (Mob entity : entities) {
            if (!(entity instanceof Warden)) continue;
            Warden warden = (Warden)entity;
            warden.f_219314_.m_216977_(warden.f_19797_ - 43);
            if (!(level.f_46441_.m_188500_() <= (double)0.1f)) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_235898_, entity.m_20185_() + (level.f_46441_.m_188500_() - 0.5), entity.m_20186_() + 1.5, entity.m_20189_() + (level.f_46441_.m_188500_() - 0.5), 0.0, 0.1, 0.0);
        }
    }

    public int getSoulAmount() {
        return this.soulAmount;
    }

    public void useSoul() {
        --this.soulAmount;
        this.syncObject(this.soulAmount);
    }

    public SoulLaserBaseBlockEntity getSelf() {
        return this;
    }

    protected EnergyStorageComponent<SoulLaserBaseBlockEntity> createEnergyStorage() {
        return new EnergyStorageComponent(0, 4, 10);
    }

    public ProgressBarComponent<SoulLaserBaseBlockEntity> getBar() {
        return this.work;
    }

    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.SPEED)) {
            return false;
        }
        return super.canAcceptAugment(augment);
    }

    public void m_6339_() {
        super.m_6339_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_18689_(() -> {
                NetworkManager networkManager = NetworkManager.get((Level)this.f_58857_);
                if (networkManager.getElement(this.f_58858_) == null) {
                    networkManager.addElement(this.createElement(this.f_58857_, this.f_58858_));
                }
            });
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void m_7651_() {
        super.m_7651_();
        if (!this.f_58857_.f_46443_ && !this.unloaded) {
            NetworkManager networkManager = NetworkManager.get((Level)this.f_58857_);
            NetworkElement pipe = networkManager.getElement(this.f_58858_);
            if (pipe != null) {
                // empty if block
            }
            networkManager.removeElement(this.f_58858_);
        }
    }

    protected NetworkElement createElement(Level level, BlockPos pos) {
        return new DefaultSoulNetworkElement(level, pos);
    }

    public SoulNetwork getNetwork() {
        return (SoulNetwork)NetworkManager.get((Level)this.f_58857_).getElement(this.f_58858_).getNetwork();
    }
}

