/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.bitwise_logic;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.bitwise_logic.BitwiseLogicPlateBlock;
import commoble.morered.bitwise_logic.ChanneledPowerStorageBlockEntity;
import commoble.morered.plate_blocks.InputSide;
import commoble.morered.plate_blocks.LogicFunction;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TwoInputBitwiseLogicPlateBlock
extends BitwiseLogicPlateBlock {
    private final LogicFunction operator;

    public TwoInputBitwiseLogicPlateBlock(BlockBehaviour.Properties properties, LogicFunction operator) {
        super(properties);
        this.operator = operator;
    }

    @Override
    protected void updatePower(Level world, BlockPos thisPos, BlockState thisState) {
        BlockEntity te = world.m_7702_(thisPos);
        if (te instanceof ChanneledPowerStorageBlockEntity) {
            ChanneledPowerStorageBlockEntity logicTE = (ChanneledPowerStorageBlockEntity)te;
            byte[] power = new byte[16];
            Direction attachmentDir = (Direction)thisState.m_61143_((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION);
            int rotationIndex = (Integer)thisState.m_61143_((Property)PlateBlockStateProperties.ROTATION);
            Direction inputSideA = BlockStateUtil.getInputDirection(attachmentDir, rotationIndex, InputSide.A.rotationsFromOutput);
            Direction inputSideC = BlockStateUtil.getInputDirection(attachmentDir, rotationIndex, InputSide.C.rotationsFromOutput);
            BlockEntity inputTileA = world.m_7702_(thisPos.m_121945_(inputSideA));
            BlockEntity inputTileC = world.m_7702_(thisPos.m_121945_(inputSideC));
            ChanneledPowerSupplier inputA = inputTileA == null ? BitwiseLogicPlateBlock.NO_POWER_SUPPLIER : (ChanneledPowerSupplier)inputTileA.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, inputSideA.m_122424_()).orElse((Object)NO_POWER_SUPPLIER);
            ChanneledPowerSupplier inputC = inputTileC == null ? BitwiseLogicPlateBlock.NO_POWER_SUPPLIER : (ChanneledPowerSupplier)inputTileC.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, inputSideC.m_122424_()).orElse((Object)NO_POWER_SUPPLIER);
            for (int i = 0; i < 16; ++i) {
                boolean inputBitA = inputA.getPowerOnChannel(world, thisPos, thisState, attachmentDir, i) > 0;
                boolean inputBitC = inputC.getPowerOnChannel(world, thisPos, thisState, attachmentDir, i) > 0;
                boolean outputBit = this.operator.apply(inputBitA, false, inputBitC);
                power[i] = (byte)(outputBit ? 31 : 0);
            }
            logicTE.setPower(power);
        }
    }

    @Override
    public boolean canConnectToAdjacentCable(@Nonnull BlockGetter world, @Nonnull BlockPos thisPos, @Nonnull BlockState thisState, @Nonnull BlockPos wirePos, @Nonnull BlockState wireState, @Nonnull Direction wireFace, @Nonnull Direction directionToWire) {
        Direction plateAttachmentDir = (Direction)thisState.m_61143_((Property)PlateBlock.ATTACHMENT_DIRECTION);
        Direction primaryOutputDirection = PlateBlockStateProperties.getOutputDirection(thisState);
        Direction attachmentDir = (Direction)thisState.m_61143_((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION);
        int rotationIndex = (Integer)thisState.m_61143_((Property)PlateBlockStateProperties.ROTATION);
        Direction inputSideA = BlockStateUtil.getInputDirection(attachmentDir, rotationIndex, InputSide.A.rotationsFromOutput);
        Direction inputSideC = BlockStateUtil.getInputDirection(attachmentDir, rotationIndex, InputSide.C.rotationsFromOutput);
        return plateAttachmentDir == wireFace && (directionToWire == primaryOutputDirection || directionToWire == inputSideA || directionToWire == inputSideC);
    }
}

