/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import commoble.morered.MoreRed;
import commoble.morered.wire_post.AbstractPostBlock;
import commoble.morered.wire_post.WirePostBlockEntity;
import java.util.EnumSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractPoweredWirePostBlock
extends AbstractPostBlock
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final EnumSet<Direction> NO_DIRECTIONS = EnumSet.noneOf(Direction.class);
    protected static final VoxelShape[] POST_SHAPES_DUNSWE = new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)};
    private final Function<BlockState, EnumSet<Direction>> connectionGetter;

    public AbstractPoweredWirePostBlock(BlockBehaviour.Properties properties, Function<BlockState, EnumSet<Direction>> connectionGetter) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
        this.connectionGetter = connectionGetter;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MoreRed.get().redwirePostBeType.get()).m_155264_(pos, state);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWER});
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        int newPower;
        int oldPower = (Integer)state.m_61143_((Property)POWER);
        if (oldPower != (newPower = this.getNewPower(state, (LevelAccessor)world, pos))) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
        }
    }

    @Deprecated
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        int oldPower = (Integer)state.m_61143_((Property)POWER);
        int newPower = this.getNewPower(state, (LevelAccessor)world, pos);
        if (oldPower != newPower) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState attachmentState = super.m_5573_(context);
        return attachmentState == null ? null : (BlockState)attachmentState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(this.getNewPower(attachmentState, (LevelAccessor)context.m_43725_(), context.m_8083_())));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(this.getNewPower(state, world, pos)));
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null && this.getConnectableDirections(state).contains(side.m_122424_());
    }

    @Deprecated
    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction directionOfThisBlockFromCaller) {
        if (this.getConnectableDirections(blockState).contains(directionOfThisBlockFromCaller.m_122424_())) {
            return (Integer)blockState.m_61143_((Property)POWER);
        }
        return 0;
    }

    @Deprecated
    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction directionFromNeighbor) {
        return this.m_6378_(state, world, pos, directionFromNeighbor);
    }

    public EnumSet<Direction> getConnectableDirections(BlockState state) {
        return this.connectionGetter.apply(state);
    }

    public int getNewPower(BlockState state, LevelAccessor world, BlockPos pos) {
        return Math.max(0, Math.max(this.getNeighborPower(state, world, pos), this.getConnectionPower(state, world, pos)) - 1);
    }

    public int getNeighborPower(BlockState state, LevelAccessor world, BlockPos pos) {
        int maxPowerFound = 0;
        if (world instanceof Level) {
            Level level = (Level)world;
            for (Direction dir : this.getConnectableDirections(state)) {
                int signal = level.m_277185_(pos.m_121945_(dir), dir);
                maxPowerFound = Math.max(signal, maxPowerFound);
            }
        }
        return maxPowerFound;
    }

    public int getConnectionPower(BlockState state, LevelAccessor world, BlockPos pos) {
        int maxPowerFound = 0;
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof WirePostBlockEntity) {
            WirePostBlockEntity wire = (WirePostBlockEntity)be;
            for (BlockPos otherPos : wire.getRemoteConnections()) {
                BlockState otherState = world.m_8055_(otherPos);
                if (!otherState.m_61138_((Property)POWER)) continue;
                maxPowerFound = Math.max(maxPowerFound, (Integer)otherState.m_61143_((Property)POWER));
            }
        }
        return maxPowerFound;
    }

    @Override
    public void notifyNeighbors(Level world, BlockPos pos, BlockState state) {
        EnumSet<Direction> neighborDirections = this.getConnectableDirections(state);
        if (!ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)pos, (BlockState)world.m_8055_(pos), neighborDirections, (boolean)false).isCanceled()) {
            for (Direction dir : neighborDirections) {
                BlockPos neighborPos = pos.m_121945_(dir);
                world.m_46586_(neighborPos, (Block)this, pos);
                if (!world.m_8055_(neighborPos).shouldCheckWeakPower((SignalGetter)world, neighborPos, dir)) continue;
                world.m_46672_(neighborPos, (Block)this);
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof WirePostBlockEntity) {
                WirePostBlockEntity wire = (WirePostBlockEntity)blockEntity;
                wire.notifyConnections();
            }
        }
    }
}

