/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import commoble.morered.MoreRed;
import commoble.morered.ServerConfig;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WireBreakPacket;
import commoble.morered.wire_post.WirePostBlockEntity;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class WireSpoolItem
extends Item {
    public static final String LAST_POST_POS = "last_post_pos";
    protected final TagKey<Block> postBlockTag;

    public WireSpoolItem(Item.Properties properties, TagKey<Block> postBlockTag) {
        super(properties);
        this.postBlockTag = postBlockTag;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult interactionResult;
        BlockEntity blockEntity;
        BlockPos pos;
        Level level = context.m_43725_();
        if (level.m_8055_(pos = context.m_8083_()).m_204336_(this.postBlockTag) && (blockEntity = level.m_7702_(pos)) instanceof WirePostBlockEntity) {
            WirePostBlockEntity post = (WirePostBlockEntity)blockEntity;
            interactionResult = this.onUseOnPost(level, pos, post, context.m_43722_(), context.m_43723_());
        } else {
            interactionResult = super.m_6225_(context);
        }
        return interactionResult;
    }

    private InteractionResult onUseOnPost(Level level, BlockPos pos, @Nonnull WirePostBlockEntity post, ItemStack stack, Player player) {
        if (!level.f_46443_) {
            CompoundTag nbt = stack.m_41737_(LAST_POST_POS);
            if (nbt == null) {
                stack.m_41700_(LAST_POST_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
            } else {
                BlockPos lastPos = NbtUtils.m_129239_((CompoundTag)nbt);
                if (lastPos.equals((Object)pos)) {
                    stack.m_41749_(LAST_POST_POS);
                } else if (post.hasRemoteConnection(lastPos)) {
                    WirePostBlockEntity.removeConnection((LevelAccessor)level, pos, lastPos);
                    stack.m_41749_(LAST_POST_POS);
                } else {
                    BlockPos upperPos;
                    boolean lastPosIsHigher = pos.m_123342_() < lastPos.m_123342_();
                    BlockPos lowerPos = lastPosIsHigher ? pos : lastPos;
                    Vec3 hit = SlackInterpolator.getWireRaytraceHit(lowerPos, upperPos = lastPosIsHigher ? lastPos : pos, (BlockGetter)level);
                    if (hit != null) {
                        stack.m_41749_(LAST_POST_POS);
                        if (player instanceof ServerPlayer && level instanceof ServerLevel) {
                            MoreRed.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new WireBreakPacket(WirePostBlockEntity.getConnectionVector(lowerPos), WirePostBlockEntity.getConnectionVector(upperPos)));
                            ((ServerLevel)level).m_8624_((ServerPlayer)player, (ParticleOptions)DustParticleOptions.f_123656_, false, hit.f_82479_, hit.f_82480_, hit.f_82481_, 5, 0.05, 0.05, 0.05, 0.0);
                            ((ServerPlayer)player).m_6330_(SoundEvents.f_12587_, SoundSource.BLOCKS, 0.5f, 2.0f);
                        }
                    } else if (pos.m_123314_((Vec3i)lastPos, ((Double)ServerConfig.INSTANCE.maxWirePostConnectionRange().get()).doubleValue())) {
                        stack.m_41749_(LAST_POST_POS);
                        BlockEntity blockEntity = level.m_7702_(lastPos);
                        if (blockEntity instanceof WirePostBlockEntity) {
                            WirePostBlockEntity lastPost = (WirePostBlockEntity)blockEntity;
                            WirePostBlockEntity.addConnection((LevelAccessor)level, post, lastPost);
                        }
                        stack.m_41622_(1, (LivingEntity)player, thePlayer -> thePlayer.m_21166_(EquipmentSlot.MAINHAND));
                    } else {
                        stack.m_41700_(LAST_POST_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
                    }
                }
            }
            level.m_5594_(null, pos, SoundEvents.f_12444_, SoundSource.BLOCKS, 0.2f + level.f_46441_.m_188501_() * 0.1f, 0.7f + level.f_46441_.m_188501_() * 0.1f);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_) {
            Optional.ofNullable(stack.m_41737_(LAST_POST_POS)).map(nbt -> NbtUtils.m_129239_((CompoundTag)nbt)).filter(pos -> this.shouldRemoveConnection((BlockPos)pos, worldIn, entityIn)).ifPresent(pos -> WireSpoolItem.breakPendingConnection(stack, pos, entityIn, worldIn));
        }
    }

    public boolean shouldRemoveConnection(BlockPos connectionPos, Level world, Entity holder) {
        double maxDistance = (Double)ServerConfig.INSTANCE.maxWirePostConnectionRange().get();
        if (holder.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)connectionPos)) > maxDistance * maxDistance) {
            return true;
        }
        return !world.m_8055_(connectionPos).m_204336_(this.postBlockTag);
    }

    public static void breakPendingConnection(ItemStack stack, BlockPos connectingPos, Entity holder, Level world) {
        stack.m_41749_(LAST_POST_POS);
        if (holder instanceof ServerPlayer) {
            MoreRed.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)holder), (Object)new WireBreakPacket(WirePostBlockEntity.getConnectionVector(connectingPos), new Vec3(holder.m_20185_(), holder.m_20188_(), holder.m_20189_())));
        }
    }
}

