/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.dweller.Dweller;

public class DwellerModel<T extends Dweller>
extends AgeableListModel<T> {
    private final ModelPart torso;
    private final ModelPart mane;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public DwellerModel(ModelPart root) {
        this.torso = root.m_171324_("torso");
        this.mane = this.torso.m_171324_("mane");
        this.head = root.m_171324_("head");
        this.rightLeg = root.m_171324_("rightLeg");
        this.leftLeg = root.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer(float torsoInflate) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition torso = partdefinition.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-6.0f, -3.0f, -6.0f, 12.0f, 8.0f, 15.0f, new CubeDeformation(torsoInflate)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)3.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition mane = torso.m_171599_("mane", CubeListBuilder.m_171558_().m_171514_(41, 10).m_171488_(-1.0f, -6.0f, -8.0f, 2.0f, 3.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -3.0f, -8.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = torso.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(52, 57).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)9.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-5.0f, 0.0f, -3.0f, 10.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-2.0f));
        PartDefinition trunk = head.m_171599_("trunk", CubeListBuilder.m_171558_().m_171514_(39, 26).m_171488_(-2.0f, 0.0f, -9.0f, 4.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)-1.0f, (float)2.618f, (float)0.0f, (float)0.0f));
        PartDefinition trunk2 = trunk.m_171599_("trunk2", CubeListBuilder.m_171558_().m_171514_(39, 0).m_171488_(-1.0f, 0.0f, -7.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-9.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(52, 40).m_171488_(-4.0f, -2.0f, -3.0f, 4.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)5.0f, (float)6.0f));
        PartDefinition rightFoot = rightLeg.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171488_(-1.0f, -3.0f, 0.0f, 2.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)9.0f, (float)3.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(32, 46).m_171488_(0.0f, -2.0f, -3.0f, 4.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)5.0f, (float)6.0f));
        PartDefinition leftFoot = leftLeg.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171488_(-1.0f, -3.0f, 0.0f, 2.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)9.0f, (float)3.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = -1.3963f + headPitch * ((float)Math.PI / 180);
        this.leftLeg.f_104203_ = -0.6109f + Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.66f * limbSwingAmount;
        this.rightLeg.f_104203_ = -0.6109f + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.66f * limbSwingAmount;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.head, (Object)this.torso, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.mane.f_104207_ = !((Dweller)((Object)entity)).m_6254_();
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
    }
}

