/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.lib.datamanager.IDataManager;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileDataManager<T extends BlockEntity>
implements IDataManager {
    protected LinkedList<IManagedData> managedDataList = new LinkedList();
    public final T tile;
    private int lastDirty = -9999;
    private int maxSaveInterval = 0;

    public TileDataManager(T tile) {
        this.tile = tile;
    }

    public void setMaxSaveInterval(int maxSaveInterval) {
        this.maxSaveInterval = maxSaveInterval;
    }

    public <M extends IManagedData> M register(M managedData) {
        managedData.init(this, this.managedDataList.size());
        this.managedDataList.add(managedData);
        return managedData;
    }

    @Override
    public void detectAndSendChanges() {
        for (IManagedData data : this.managedDataList) {
            if (!data.flags().syncTile || !data.isDirty(true)) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            syncPacket.sendToChunk(this.tile);
        }
    }

    public void detectAndSendChangesToListeners(Collection<Player> listeners) {
        for (IManagedData data : this.managedDataList) {
            if (!data.flags().syncContainer || !data.isDirty(true)) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            DataUtils.forEachMatch(listeners, p -> p instanceof ServerPlayer, p -> syncPacket.sendToPlayer((ServerPlayer)p));
        }
    }

    public void forceContainerSync(List<ContainerListener> listeners) {
        if (!this.tile.m_58904_().f_46443_) {
            for (IManagedData data : this.managedDataList) {
                if (!data.flags().syncContainer) continue;
                PacketCustom syncPacket = this.createSyncPacket();
                syncPacket.writeByte((int)((byte)data.getIndex()));
                data.toBytes((MCDataOutput)syncPacket);
                DataUtils.forEachMatch(listeners, p -> p instanceof ServerPlayer, p -> syncPacket.sendToPlayer((ServerPlayer)p));
            }
        }
    }

    public void forceSync() {
        if (!this.tile.m_58904_().f_46443_) {
            for (IManagedData data : this.managedDataList) {
                if (!data.flags().syncTile) continue;
                PacketCustom syncPacket = this.createSyncPacket();
                syncPacket.writeByte((int)((byte)data.getIndex()));
                data.toBytes((MCDataOutput)syncPacket);
                syncPacket.sendToChunk(this.tile);
            }
        }
    }

    public void forcePlayerSync(ServerPlayer player) {
        if (!this.tile.m_58904_().f_46443_) {
            for (IManagedData data : this.managedDataList) {
                if (!data.flags().syncContainer) continue;
                PacketCustom syncPacket = this.createSyncPacket();
                syncPacket.writeByte((int)((byte)data.getIndex()));
                data.toBytes((MCDataOutput)syncPacket);
                syncPacket.sendToPlayer(player);
            }
        }
    }

    public void forceSync(IManagedData data) {
        if (!this.tile.m_58904_().f_46443_) {
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            syncPacket.sendToChunk(this.tile);
        }
    }

    @Override
    public PacketCustom createSyncPacket() {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL, 1);
        packet.writePos(this.tile.m_58899_());
        return packet;
    }

    @Override
    public void receiveSyncData(MCDataInput input) {
        int index = input.readByte() & 0xFF;
        IManagedData data = this.getDataByIndex(index);
        if (data != null) {
            data.fromBytes(input);
            if (data.flags().triggerUpdate) {
                BlockState state = this.tile.m_58904_().m_8055_(this.tile.m_58899_());
                this.tile.m_58904_().m_7260_(this.tile.m_58899_(), state, state, 3);
            }
        }
    }

    @Override
    public IManagedData getDataByName(String name) {
        return DataUtils.firstMatch(this.managedDataList, data -> data.getName().equals(name));
    }

    @Override
    public IManagedData getDataByIndex(int index) {
        return DataUtils.firstMatch(this.managedDataList, data -> data.getIndex() == index);
    }

    @Override
    public void writeToNBT(CompoundTag compound) {
        CompoundTag dataTag = new CompoundTag();
        DataUtils.forEachMatch(this.managedDataList, data -> data.flags().saveNBT, data -> data.toNBT(dataTag));
        compound.m_128365_("bc_managed_data", (Tag)dataTag);
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        if (compound.m_128425_("bc_managed_data", 10)) {
            CompoundTag dataTag = compound.m_128469_("bc_managed_data");
            DataUtils.forEachMatch(this.managedDataList, data -> data.flags().saveNBT, data -> data.fromNBT(dataTag));
        }
    }

    @Override
    public void markDirty() {
        if (this.tile.m_58904_() != null && !this.tile.m_58904_().f_46443_) {
            if (this.maxSaveInterval == 0) {
                this.tile.m_6596_();
            } else if (TimeKeeper.getServerTick() > this.lastDirty + this.maxSaveInterval) {
                this.lastDirty = TimeKeeper.getServerTick();
                this.tile.m_6596_();
            }
            for (IManagedData data : this.managedDataList) {
                if (!data.flags().syncOnSet || !data.isDirty(true)) continue;
                PacketCustom syncPacket = this.createSyncPacket();
                syncPacket.writeByte((int)((byte)data.getIndex()));
                data.toBytes((MCDataOutput)syncPacket);
                DelayedTask.server(1, () -> syncPacket.sendToChunk(this.tile));
            }
        }
    }

    @Override
    public boolean isClientSide() {
        return this.tile.m_58898_() && this.tile.m_58904_().f_46443_;
    }

    @Override
    public void sendToServer(IManagedData data) {
        AbstractContainerMenu container;
        Player player;
        if (this.tile.m_58904_().f_46443_ && data.flags().allowClientControl && (player = BrandonsCore.proxy.getClientPlayer()) != null && (container = player.f_36096_) instanceof ContainerBCTile && ((ContainerBCTile)container).tile == this.tile) {
            PacketCustom packet = ((ContainerBCTile)container).createServerBoundPacket(3);
            packet.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)packet);
            packet.sendToServer();
        }
    }

    public void receiveDataFromClient(MCDataInput input) {
        int index = input.readByte() & 0xFF;
        IManagedData data = this.getDataByIndex(index);
        if (data != null && data.flags().allowClientControl) {
            data.fromBytes(input);
            data.validate();
            data.markDirty();
        }
    }

    public void writeSyncNBT(CompoundTag compound) {
        CompoundTag dataTag = new CompoundTag();
        DataUtils.forEachMatch(this.managedDataList, data -> data.flags().syncViaPacket(), data -> data.toNBT(dataTag));
        compound.m_128365_("bc_managed_data", (Tag)dataTag);
    }

    public void readSyncNBT(CompoundTag compound) {
        if (compound.m_128425_("bc_managed_data", 10)) {
            CompoundTag dataTag = compound.m_128469_("bc_managed_data");
            DataUtils.forEachMatch(this.managedDataList, data -> data.flags().syncViaPacket(), data -> data.fromNBT(dataTag));
        }
    }

    public void writeToStackNBT(CompoundTag compound) {
        CompoundTag dataTag = new CompoundTag();
        DataUtils.forEachMatch(this.managedDataList, data -> data.flags().saveItem, data -> data.toNBT(dataTag));
        if (!dataTag.m_128456_()) {
            compound.m_128365_("bc_managed_data", (Tag)dataTag);
        }
    }

    public void readFromStackNBT(CompoundTag compound) {
        if (compound.m_128425_("bc_managed_data", 10)) {
            CompoundTag dataTag = compound.m_128469_("bc_managed_data");
            DataUtils.forEachMatch(this.managedDataList, data -> data.flags().saveItem, data -> data.fromNBT(dataTag));
        }
    }
}

