/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.client.render.RenderRegistry;
import shetiphian.endertanks.common.item.EnderFluidHandlerItemStack;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class ItemBlockEnderTank
extends BlockItem
implements ITabFiller,
IColored {
    public ItemBlockEnderTank(Block block, Item.Properties properties) {
        super(block, properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)((Object)this), (Object)"type", (stack, world, entity, number) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f))));
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (String code : StackHelper.BASE_CODES) {
            entries.m_246342_(StackHelper.create((Item)this, code, null));
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        super.m_7836_(stack, world, player);
        StackHelper.getCode(stack);
        StackHelper.getOwnerID(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return stack == null ? null : new EnderFluidHandlerItemStack(stack);
    }

    public String m_5671_(ItemStack stack) {
        return "block.endertanks.tank." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.code")).m_7220_((Component)Component.m_237113_((String)(" " + StackHelper.getCode(stack)))));
        Component owner = TankInfoHelper.formatTankOwner(StackHelper.getOwnerName(stack));
        if (owner != null) {
            tooltip.add(owner);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && data.stack != null) {
            int value = Mth.m_14045_((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }
}

