/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import cy.jdkdigital.dyenamicsandfriends.compat.CreateCompat;
import cy.jdkdigital.dyenamicsandfriends.loot.OptionalLootItem;
import cy.jdkdigital.dyenamicsandfriends.loot.condition.ModLoadedCondition;
import cy.jdkdigital.dyenamicsandfriends.loot.condition.OptionalLootItemBlockStatePropertyCondition;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;

@Mod(value="dyenamicsandfriends")
public class DyenamicsAndFriends {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "dyenamicsandfriends";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<MenuType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"dyenamicsandfriends");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"dyenamicsandfriends");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"dyenamicsandfriends");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"dyenamicsandfriends");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"dyenamicsandfriends");
    public static final DeferredRegister<LootPoolEntryType> LOOT_POOL_ENTRIES = DeferredRegister.create((ResourceKey)Registries.f_257032_, (String)"dyenamicsandfriends");
    public static final DeferredRegister<LootItemConditionType> LOOT_POOL_CONDITIONS = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"dyenamicsandfriends");
    public static final RegistryObject<LootPoolEntryType> OPTIONAL_LOOT_ITEM = LOOT_POOL_ENTRIES.register("optional_loot_item", () -> new LootPoolEntryType((Serializer)new OptionalLootItem.Serializer()));
    public static final RegistryObject<LootItemConditionType> OPTIONAL_BLOCK_STATE_PROPERTY = LOOT_POOL_CONDITIONS.register("optional_block_state_property", () -> new LootItemConditionType((Serializer)new OptionalLootItemBlockStatePropertyCondition.Serializer()));
    public static final RegistryObject<LootItemConditionType> MOD_LOADED_CONDITION = LOOT_POOL_CONDITIONS.register("mod_loaded", () -> new LootItemConditionType((Serializer)new ModLoadedCondition.Serializer()));

    public DyenamicsAndFriends() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::onPackEvent);
        DyenamicRegistry.setup();
        DyenamicRegistry.registerCompatBlocks();
        BLOCKS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CONTAINER_TYPES.register(modEventBus);
        ITEMS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        LOOT_SERIALIZERS.register(modEventBus);
        LOOT_POOL_ENTRIES.register(modEventBus);
        LOOT_POOL_CONDITIONS.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("create")) {
            CreateCompat.setup(event);
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DyenamicRegistry.clientRegister();
    }

    private void onPackEvent(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            event.addRepositorySource((RepositorySource)new ModLoadedPackFinder(event.getPackType()));
        }
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            event.addRepositorySource((RepositorySource)new ModLoadedPackFinder(event.getPackType()));
        }
    }

    private static class ModLoadedPackFinder
    implements RepositorySource {
        private final PackType packType;

        public ModLoadedPackFinder(PackType packType) {
            this.packType = packType;
        }

        public void m_7686_(Consumer<Pack> packLoader) {
            IModFileInfo modFile = ((ModContainer)ModList.get().getModContainerById(DyenamicsAndFriends.MODID).get()).getModInfo().getOwningFile();
            for (String modId : DyenamicRegistry.MODS) {
                try {
                    if (!ModList.get().isLoaded(modId) || !DyenamicRegistry.MODS.contains(modId)) continue;
                    if (this.packType.equals((Object)PackType.SERVER_DATA)) {
                        Pack pack = Pack.m_245429_((String)("dyenamicsandfriends:" + modId), (Component)Component.m_237115_((String)("dataPack.dyenamicsandfriends." + modId)), (boolean)true, name -> new PathPackResources("dyenamicsandfriends:" + modId, true, modFile.getFile().findResource(new String[]{"compat_packs/" + modId + "/"})), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                        packLoader.accept(pack);
                    }
                    if (!this.packType.equals((Object)PackType.CLIENT_RESOURCES) || !modId.equals("connectedglass")) continue;
                    LOGGER.info("adding connected glass resourcepack");
                    Pack clientPack = Pack.m_245429_((String)("dyenamicsandfriends:" + modId + "_resources"), (Component)Component.m_237115_((String)("resourcePack.dyenamicsandfriends." + modId)), (boolean)true, name -> new PathPackResources("dyenamicsandfriends:" + modId + "_resources", true, modFile.getFile().findResource(new String[]{"compat_packs/" + modId + "/"})), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    packLoader.accept(clientPack);
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to load compat pack: " + modId);
                }
            }
        }
    }
}

