/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.common.item.ae2;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AECableType;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.items.tools.powered.ColorApplicatorItem;
import appeng.parts.networking.CablePart;
import appeng.util.Platform;
import cy.jdkdigital.dyenamics.common.items.DyenamicDyeItem;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.item.ae2.DyenamicsColoredPartItem;
import cy.jdkdigital.dyenamicsandfriends.compat.Ae2Compat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class DyenamicsColorApplicatorItem
extends ColorApplicatorItem {
    public DyenamicsColorApplicatorItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult m_6880_(ItemStack is, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        return super.m_6880_(is, player, interactionTarget, usedHand);
    }

    public Component m_7626_(ItemStack is) {
        return super.m_7626_(is);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Item item;
        ItemStack paintBall;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack is = context.m_43722_();
        Direction side = context.m_43719_();
        Player p = context.m_43723_();
        if (p == null && level instanceof ServerLevel) {
            p = Platform.getFakePlayer((ServerLevel)((ServerLevel)level), null);
        }
        if (!(paintBall = this.getColor(is)).m_41619_() && (item = paintBall.m_41720_()) instanceof DyenamicDyeItem) {
            DyenamicDyeItem dyenamicDyeItem = (DyenamicDyeItem)item;
            AEItemKey paintBallKey = AEItemKey.of((ItemStack)paintBall);
            StorageCell inv = StorageCells.getCellInventory((ItemStack)is, null);
            if (inv != null) {
                Block blk = level.m_8055_(pos).m_60734_();
                DyenamicDyeColor color = dyenamicDyeItem.getDyeColor();
                if (color != null && this.getAECurrentPower(is) > 100.0 && this.recolourBlock(blk, side, level, pos, color, p)) {
                    this.consumeItem(is, paintBallKey, false);
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            }
        }
        return super.m_6225_(context);
    }

    private boolean recolourBlock(Block blk, Direction side, Level level, BlockPos pos, DyenamicDyeColor newColor, @Nullable Player player) {
        BlockState state = level.m_8055_(pos);
        Block recolored = Ae2Compat.BlockRecolorer.recolor(blk, newColor);
        if (recolored != blk) {
            BlockState newState = recolored.m_49966_();
            for (Property prop : newState.m_61147_()) {
                newState = DyenamicsColorApplicatorItem.copyProp(state, newState, prop);
            }
            return level.m_46597_(pos, newState);
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CableBusBlockEntity) {
            IPart cable;
            CableBusBlockEntity cableBusBlockEntity = (CableBusBlockEntity)be;
            if (player != null && (cable = cableBusBlockEntity.getCableBus().getPart(null)) instanceof CablePart) {
                CablePart pc = (CablePart)cable;
                return DyenamicsColorApplicatorItem.changeCableColor(pc, newColor, player);
            }
        }
        return false;
    }

    private static <T extends Comparable<T>> BlockState copyProp(BlockState oldState, BlockState newState, Property<T> prop) {
        if (newState.m_61138_(prop)) {
            return (BlockState)newState.m_61124_(prop, oldState.m_61143_(prop));
        }
        return newState;
    }

    public boolean isBlackListed(ItemStack cellItem, AEKey requestedAddition) {
        AEItemKey itemKey;
        if (requestedAddition instanceof AEItemKey && (itemKey = (AEItemKey)requestedAddition).getItem() instanceof DyenamicDyeItem) {
            return false;
        }
        return super.isBlackListed(cellItem, requestedAddition);
    }

    static boolean changeCableColor(CablePart cable, DyenamicDyeColor newColor, Player who) {
        block16: {
            block15: {
                IPartItem iPartItem = cable.getPartItem();
                if (!(iPartItem instanceof DyenamicsColoredPartItem)) break block15;
                DyenamicsColoredPartItem partItem = (DyenamicsColoredPartItem)iPartItem;
                if (partItem.color == newColor) break block16;
            }
            IPartItem newPart = null;
            if (cable.getCableConnectionType() == AECableType.GLASS) {
                newPart = (IPartItem)Ae2Compat.GLASS_CABLES.get(newColor).get();
            } else if (cable.getCableConnectionType() == AECableType.COVERED) {
                newPart = (IPartItem)Ae2Compat.COVERED_CABLES.get(newColor).get();
            } else if (cable.getCableConnectionType() == AECableType.SMART) {
                newPart = (IPartItem)Ae2Compat.SMART_CABLES.get(newColor).get();
            } else if (cable.getCableConnectionType() == AECableType.DENSE_COVERED) {
                newPart = (IPartItem)Ae2Compat.COVERED_DENSE_CABLES.get(newColor).get();
            } else if (cable.getCableConnectionType() == AECableType.DENSE_SMART) {
                newPart = (IPartItem)Ae2Compat.SMART_DENSE_CABLES.get(newColor).get();
            }
            if (newPart != null) {
                if (cable.isClientSide()) {
                    return true;
                }
                try {
                    Ae2Compat.setPartItemHandle.invokeWithArguments(cable, newPart);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                cable.getMainNode().setGridColor(cable.getCableColor());
                cable.getHost().markForUpdate();
                cable.getHost().markForSave();
                return true;
            }
        }
        return false;
    }
}

