/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import com.supermartijn642.connectedglass.CGGlassType;
import cy.jdkdigital.dyenamics.common.blocks.DyenamicStainedGlassBlock;
import cy.jdkdigital.dyenamics.common.blocks.DyenamicStainedGlassPane;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.block.TintedDyenamicStainedGlassBlock;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegistryObject;

public class ConnectedGlassCompat {
    public static final List<RegistryObject<? extends Block>> GLASS_BLOCKS = new ArrayList<RegistryObject<? extends Block>>();
    public static final List<RegistryObject<? extends Block>> GLASS_PANES = new ArrayList<RegistryObject<? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        for (CGGlassType glassType : CGGlassType.values()) {
            String typeName = glassType.name().toLowerCase(Locale.ROOT);
            String prefix = "connectedglass_" + typeName + "_" + color.m_7912_();
            RegistryObject<? extends Block> block = DyenamicRegistry.registerBlock(prefix, () -> glassType.isTinted ? new TintedDyenamicStainedGlassBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)) : new DyenamicStainedGlassBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_)), true);
            GLASS_BLOCKS.add(block);
            if (!glassType.hasPanes) continue;
            GLASS_PANES.add(DyenamicRegistry.registerBlock(prefix + "_pane", () -> new DyenamicStainedGlassPane(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_)), true));
        }
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256791_)) {
            GLASS_BLOCKS.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            GLASS_PANES.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    public static class Client {
        public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            GLASS_BLOCKS.forEach(holder -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)holder.get()), (RenderType)RenderType.m_110466_()));
            GLASS_PANES.forEach(holder -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)holder.get()), (RenderType)RenderType.m_110466_()));
        }
    }
}

