/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.registry;

import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.DyenamicsAndFriends;
import cy.jdkdigital.dyenamicsandfriends.compat.AnotherFurnitureCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.BotanyPotsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.BumblezoneCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ComfortsCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ConnectedGlassCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.CreateCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ElevatoridCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.FurnishCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.ProductiveBeesCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.RegionsUnexploredCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.SleepTightCompat;
import cy.jdkdigital.dyenamicsandfriends.compat.SophisticatedBackpacksCompat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public class DyenamicRegistry {
    public static final List<String> MODS = new ArrayList<String>(){
        {
            this.add("another_furniture");
            this.add("productivebees");
            this.add("connectedglass");
            this.add("botanypots");
            this.add("comforts");
            this.add("elevatorid");
            this.add("furnish");
            this.add("regions_unexplored");
            this.add("sleep_tight");
            this.add("sophisticatedbackpacks");
            this.add("create");
            this.add("the_bumblezone");
        }
    };

    public static void setup() {
    }

    public static void registerCompatBlocks() {
        DyenamicsAndFriends.LOGGER.info("registerCompatBlocks");
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            if (ModList.get().isLoaded("create")) {
                CreateCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("createdeco")) {
                // empty if block
            }
            if (ModList.get().isLoaded("another_furniture")) {
                AnotherFurnitureCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("botanypots")) {
                BotanyPotsCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("comforts")) {
                ComfortsCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("elevatorid")) {
                ElevatoridCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("productivebees")) {
                ProductiveBeesCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("farmersdelight")) {
                // empty if block
            }
            if (ModList.get().isLoaded("reliquary")) {
                // empty if block
            }
            if (ModList.get().isLoaded("snowyspirit")) {
                // empty if block
            }
            if (ModList.get().isLoaded("supplementaries")) {
                // empty if block
            }
            if (ModList.get().isLoaded("suppsquared")) {
                // empty if block
            }
            if (ModList.get().isLoaded("regions_unexplored")) {
                RegionsUnexploredCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("waystones")) {
                // empty if block
            }
            if (ModList.get().isLoaded("quark")) {
                // empty if block
            }
            if (ModList.get().isLoaded("handcrafted")) {
                // empty if block
            }
            if (ModList.get().isLoaded("furnish")) {
                FurnishCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("skinnedlanterns")) {
                // empty if block
            }
            if (ModList.get().isLoaded("nightlights")) {
                // empty if block
            }
            if (ModList.get().isLoaded("cfm")) {
                // empty if block
            }
            if (ModList.get().isLoaded("chalk")) {
                // empty if block
            }
            if (ModList.get().isLoaded("oreganized")) {
                // empty if block
            }
            if (ModList.get().isLoaded("ceramics")) {
                // empty if block
            }
            if (ModList.get().isLoaded("glazedresymmetry")) {
                // empty if block
            }
            if (ModList.get().isLoaded("clayworks")) {
                // empty if block
            }
            if (ModList.get().isLoaded("the_bumblezone")) {
                BumblezoneCompat.registerBlocks(color);
            }
            if (ModList.get().isLoaded("sleep_tight")) {
                SleepTightCompat.registerBlocks(color);
            }
            if (!ModList.get().isLoaded("connectedglass")) continue;
            ConnectedGlassCompat.registerBlocks(color);
        }
        if (ModList.get().isLoaded("ae2")) {
            // empty if block
        }
        if (ModList.get().isLoaded("create")) {
            CreateCompat.postRegister();
        }
        if (ModList.get().isLoaded("sophisticatedbackpacks")) {
            SophisticatedBackpacksCompat.postRegister();
        }
    }

    public static void clientRegister() {
    }

    public static RegistryObject<? extends Block> registerBlock(String name, Supplier<? extends Block> sup, boolean registerItem) {
        RegistryObject block = DyenamicsAndFriends.BLOCKS.register(name, sup);
        if (registerItem) {
            DyenamicRegistry.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    public static RegistryObject<? extends Block> registerBlock(String name, Supplier<? extends Block> sup, @Nullable Supplier<Item> itemSupplier) {
        RegistryObject block = DyenamicsAndFriends.BLOCKS.register(name, sup);
        if (itemSupplier != null) {
            DyenamicRegistry.registerItem(name, itemSupplier);
        }
        return block;
    }

    public static RegistryObject<? extends Item> registerItem(String name, @Nullable Supplier<Item> itemSupplier) {
        return DyenamicsAndFriends.ITEMS.register(name, itemSupplier);
    }

    public static <E extends BlockEntity, T extends BlockEntityType<E>> Supplier<T> registerBlockEntity(String id, Supplier<T> supplier) {
        return DyenamicsAndFriends.BLOCK_ENTITIES.register(id, supplier);
    }

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityType.BlockEntitySupplier<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(factory, (Block[])blocks).m_58966_(null);
    }

    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (ModList.get().isLoaded("botanypots")) {
            BotanyPotsCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("create")) {
            CreateCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("comforts")) {
            ComfortsCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            // empty if block
        }
        if (ModList.get().isLoaded("furnish")) {
            FurnishCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("ceramics")) {
            // empty if block
        }
        if (ModList.get().isLoaded("sleep_tight")) {
            SleepTightCompat.Client.registerBlockEntityRenderers(event);
        }
        if (ModList.get().isLoaded("supplementaries")) {
            // empty if block
        }
        if (ModList.get().isLoaded("connectedglass")) {
            ConnectedGlassCompat.Client.registerBlockEntityRenderers(event);
        }
    }

    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        if (ModList.get().isLoaded("chalk")) {
            // empty if block
        }
        if (ModList.get().isLoaded("elevatorid")) {
            ElevatoridCompat.Client.registerBlockColors(event);
        }
    }

    public static void registerBlockRendering(FMLClientSetupEvent event) {
        if (ModList.get().isLoaded("ceramics")) {
            // empty if block
        }
        if (ModList.get().isLoaded("supplementaries")) {
            // empty if block
        }
        if (ModList.get().isLoaded("suppsquared")) {
            // empty if block
        }
        if (ModList.get().isLoaded("chalk")) {
            // empty if block
        }
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        if (ModList.get().isLoaded("chalk")) {
            // empty if block
        }
        if (ModList.get().isLoaded("elevatorid")) {
            ElevatoridCompat.Client.bakeModel(event);
        }
    }

    public static void onBlockInteract(PlayerInteractEvent event) {
        if (ModList.get().isLoaded("productivebees")) {
            ProductiveBeesCompat.blockInteract(event);
        }
    }

    public static void onEntityPlace(BlockEvent.EntityPlaceEvent event) {
        if (ModList.get().isLoaded("furnish")) {
            FurnishCompat.entityPlace(event);
        }
    }

    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (ModList.get().isLoaded("farmersdelight")) {
            // empty if block
        }
        if (ModList.get().isLoaded("create")) {
            CreateCompat.playerRightClick(event);
        }
    }

    public static Block getDyenamicsBlock(DyenamicDyeColor color, String block) {
        return (Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(color.m_7912_())).get(block)).get();
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("ae2")) {
            // empty if block
        }
    }
}

