/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.definitions.AEItems;
import gripe._90.arseng.me.cell.ISourceCellItem;
import gripe._90.arseng.me.key.SourceKey;
import gripe._90.arseng.me.key.SourceKeyType;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SourceCellInventory
implements StorageCell {
    private static final String AMOUNT = "amount";
    private final ISourceCellItem cell;
    private final ItemStack stack;
    private final ISaveProvider container;
    private long sourceAmount;
    private boolean isPersisted = true;

    public SourceCellInventory(ISourceCellItem cell, ItemStack stack, ISaveProvider container) {
        this.cell = cell;
        this.stack = stack;
        this.container = container;
        this.sourceAmount = this.getTag().m_128454_(AMOUNT);
    }

    public long getTotalBytes() {
        return this.cell.getTotalBytes();
    }

    public long getUsedBytes() {
        int amountPerByte = SourceKeyType.TYPE.getAmountPerByte();
        return (this.sourceAmount + (long)amountPerByte - 1L) / (long)amountPerByte;
    }

    public long getMaxSource() {
        return this.cell.getTotalBytes() * (long)SourceKeyType.TYPE.getAmountPerByte();
    }

    private CompoundTag getTag() {
        return this.stack.m_41784_();
    }

    public CellState getStatus() {
        if (this.sourceAmount == 0L) {
            return CellState.EMPTY;
        }
        if (this.sourceAmount == this.getMaxSource()) {
            return CellState.FULL;
        }
        if (this.sourceAmount > this.getMaxSource() / 2L) {
            return CellState.TYPES_FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cell.getIdleDrain();
    }

    public IUpgradeInventory getUpgrades() {
        return this.cell.getUpgrades(this.stack);
    }

    private void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !(what instanceof SourceKey)) {
            return 0L;
        }
        long inserted = Math.min(amount, Math.max(0L, this.getMaxSource() - this.sourceAmount));
        if (mode == Actionable.MODULATE) {
            this.sourceAmount += inserted;
            this.saveChanges();
        }
        return this.getUpgrades().isInstalled((ItemLike)AEItems.VOID_CARD) ? amount : inserted;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentAmount = this.sourceAmount;
        if (this.sourceAmount > 0L && Objects.equals(SourceKey.KEY, what)) {
            if (mode == Actionable.MODULATE) {
                this.sourceAmount = Math.max(0L, this.sourceAmount - extractAmount);
                this.saveChanges();
            }
            return Math.min(extractAmount, currentAmount);
        }
        return 0L;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.sourceAmount < 0L) {
            this.getTag().m_128473_(AMOUNT);
        } else {
            this.getTag().m_128356_(AMOUNT, this.sourceAmount);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.sourceAmount > 0L) {
            out.add(SourceKey.KEY, this.sourceAmount);
        }
    }

    public Component getDescription() {
        return this.stack.m_41786_();
    }
}

