/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.mixin;

import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.source.SourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import gripe._90.arseng.block.entity.IAdvancedSourceTile;
import gripe._90.arseng.definition.ArsEngCapabilities;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SourceUtil.class}, remap=false)
public abstract class SourceUtilMixin {
    @Inject(method={"canGiveSource"}, at={@At(value="RETURN")})
    private static void addCapToGive(BlockPos pos, Level world, int range, CallbackInfoReturnable<List<ISpecialSourceProvider>> cir) {
        List posList = (List)cir.getReturnValue();
        BlockPos.m_121985_((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            BlockEntity be;
            if (world.m_46749_(b) && (be = world.m_7702_(b)) != null) {
                be.getCapability(ArsEngCapabilities.SOURCE_TILE, IAdvancedSourceTile.getDirTo(pos, b)).ifPresent(sourceTile -> {
                    SourceProvider provider;
                    if (sourceTile.canAcceptSource() && sourceTile.sourcelinksCanProvidePower() && !posList.contains(provider = new SourceProvider((ISourceTile)sourceTile, b.m_7949_()))) {
                        posList.add(provider);
                    }
                });
            }
        });
    }

    @Inject(method={"canTakeSource"}, at={@At(value="RETURN")})
    private static void addCapToTake(BlockPos pos, Level world, int range, CallbackInfoReturnable<List<ISpecialSourceProvider>> cir) {
        List posList = (List)cir.getReturnValue();
        BlockPos.m_121985_((BlockPos)pos, (int)range, (int)range, (int)range).forEach(b -> {
            BlockEntity be;
            if (world.m_46749_(b) && (be = world.m_7702_(b)) != null) {
                be.getCapability(ArsEngCapabilities.SOURCE_TILE, IAdvancedSourceTile.getDirTo(pos, b)).ifPresent(sourceTile -> {
                    SourceProvider provider;
                    if (sourceTile.getSource() > 0 && sourceTile.relayCanTakePower() && !posList.contains(provider = new SourceProvider((ISourceTile)sourceTile, b.m_7949_()))) {
                        posList.add(provider);
                    }
                });
            }
        });
    }

    @Inject(method={"hasSourceNearby"}, at={@At(value="HEAD")}, cancellable=true)
    private static void addCapToNearby(BlockPos pos, Level world, int range, int source, CallbackInfoReturnable<Boolean> cir) {
        Optional nearby = BlockPos.m_121930_((BlockPos)pos, (int)range, (int)range, p -> {
            BlockEntity be = world.m_7702_(p);
            return be != null && be.getCapability(ArsEngCapabilities.SOURCE_TILE, IAdvancedSourceTile.getDirTo(pos, p)).filter(sourceTile -> sourceTile.getSource() >= source && sourceTile.relayCanTakePower()).isPresent();
        });
        if (nearby.isPresent()) {
            cir.setReturnValue((Object)true);
        }
    }
}

