/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.perk;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="ars_nouveau", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PerkAttributes {
    public static final HashMap<RegistryObject<Attribute>, UUID> UUIDS = new HashMap();
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"ars_nouveau");
    public static final RegistryObject<Attribute> WARDING = PerkAttributes.registerAttribute("ars_nouveau.perk.warding", (String id) -> new RangedAttribute(id, 0.0, 0.0, 1024.0).m_22084_(true), "07625fbb-f186-46c3-8b5f-989b747f29f8");
    public static final RegistryObject<Attribute> MANA_REGEN_BONUS = PerkAttributes.registerAttribute("ars_nouveau.perk.mana_regen", (String id) -> new RangedAttribute(id, 0.0, 0.0, 2000.0).m_22084_(true), "0c877091-ee4f-4eda-9868-4194d9a18833");
    public static final RegistryObject<Attribute> MAX_MANA = PerkAttributes.registerAttribute("ars_nouveau.perk.max_mana", (String id) -> new RangedAttribute(id, 0.0, 0.0, 10000.0).m_22084_(true), "22980b24-83e5-4683-a215-8997c4011389");
    @Deprecated
    public static final RegistryObject<Attribute> MAX_MANA_BONUS = MAX_MANA;
    @Deprecated
    public static final RegistryObject<Attribute> FLAT_MANA_BONUS = MAX_MANA;
    public static final RegistryObject<Attribute> SPELL_DAMAGE_BONUS = PerkAttributes.registerAttribute("ars_nouveau.perk.spell_damage", (String id) -> new RangedAttribute(id, 0.0, 0.0, 10000.0).m_22084_(true), "50b50137-9c92-4e64-b350-6044e9e609de");
    public static final RegistryObject<Attribute> WHIRLIESPRIG = PerkAttributes.registerAttribute("ars_nouveau.perk.saturation", (String id) -> new RangedAttribute(id, 1.0, 0.0, 10000.0).m_22084_(true), "152810f7-0d01-484e-a512-73fe70af3db7");
    public static final RegistryObject<Attribute> WIXIE = PerkAttributes.registerAttribute("ars_nouveau.perk.wixie", (String id) -> new RangedAttribute(id, 1.0, 0.0, 1024.0).m_22084_(true), "bae5d566-c9f6-4abf-9fe0-6ac140a34db1");
    public static final RegistryObject<Attribute> FEATHER = PerkAttributes.registerAttribute("ars_nouveau.perk.feather", (String id) -> new RangedAttribute(id, 0.0, 0.0, 1.0).m_22084_(true), "ee3a4090-c5f5-4a26-a9c2-69837237b35f");

    public static RegistryObject<Attribute> registerAttribute(String name, Function<String, Attribute> attribute, String uuid) {
        return PerkAttributes.registerAttribute(name, attribute, UUID.fromString(uuid));
    }

    public static RegistryObject<Attribute> registerAttribute(String name, Function<String, Attribute> attribute, UUID uuid) {
        RegistryObject registryObject = ATTRIBUTES.register(name, () -> (Attribute)attribute.apply(name));
        UUIDS.put((RegistryObject<Attribute>)registryObject, uuid);
        return registryObject;
    }

    @SubscribeEvent
    public static void modifyEntityAttributes(EntityAttributeModificationEvent event) {
        event.getTypes().stream().filter(e -> e == EntityType.f_20532_).forEach(e -> ATTRIBUTES.getEntries().forEach(v -> event.add(e, (Attribute)v.get())));
    }
}

