/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Glyph
extends ModItem {
    public AbstractSpellPart spellPart;

    public Glyph(AbstractSpellPart part) {
        super(new Item.Properties());
        this.spellPart = part;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        if (!Config.isGlyphEnabled(this.spellPart.getRegistryName())) {
            playerIn.m_213846_((Component)Component.m_237115_((String)"ars_nouveau.spell.disabled"));
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        IPlayerCap playerDataCap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)playerIn).orElse(null);
        if (playerDataCap != null) {
            if (playerDataCap.knowsGlyph(this.spellPart) || GlyphRegistry.getDefaultStartingSpells().contains(this.spellPart)) {
                playerIn.m_213846_((Component)Component.m_237113_((String)"You already know this spell!"));
                return super.m_7203_(worldIn, playerIn, handIn);
            }
            if (playerDataCap.unlockGlyph(this.spellPart)) {
                CapabilityRegistry.EventHandler.syncPlayerCap(playerIn);
                playerIn.m_21120_(handIn).m_41774_(1);
                playerIn.m_213846_((Component)Component.m_237113_((String)("Unlocked " + this.spellPart.getName())));
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public Component m_7626_(ItemStack pStack) {
        return Component.m_237110_((String)"ars_nouveau.glyph_of", (Object[])new Object[]{this.spellPart.getLocaleName()});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        if (this.spellPart == null) {
            return;
        }
        if (!Config.isGlyphEnabled(this.spellPart.getRegistryName())) {
            tooltip2.add((Component)Component.m_237115_((String)"tooltip.ars_nouveau.glyph_disabled"));
        } else if (this.spellPart != null) {
            tooltip2.add((Component)Component.m_237110_((String)"tooltip.ars_nouveau.glyph_level", (Object[])new Object[]{this.spellPart.getConfigTier().value}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)));
            tooltip2.add((Component)Component.m_237115_((String)"ars_nouveau.schools"));
            for (SpellSchool s : this.spellPart.spellSchools) {
                tooltip2.add(s.getTextComponent());
            }
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        IPlayerCap playerDataCap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)Minecraft.m_91087_().f_91074_).orElse(null);
        if (playerDataCap != null) {
            if (playerDataCap.knowsGlyph(this.spellPart) || GlyphRegistry.getDefaultStartingSpells().contains(this.spellPart)) {
                tooltip2.add((Component)Component.m_237115_((String)"tooltip.ars_nouveau.glyph_known").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)));
            } else {
                tooltip2.add((Component)Component.m_237115_((String)"tooltip.ars_nouveau.glyph_unknown").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED)));
            }
        }
        tooltip2.add((Component)Component.m_237115_((String)" "));
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84873_())) {
            tooltip2.add(this.spellPart.getBookDescLang());
        } else {
            tooltip2.add((Component)Component.m_237110_((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84875_()}));
        }
    }
}

