/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.connectedglass.data;

import com.supermartijn642.connectedglass.CGGlassType;
import com.supermartijn642.connectedglass.CGPaneBlock;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;
import com.supermartijn642.fusion.api.util.Pair;
import java.util.Arrays;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;

public class CGFusionModelGenerator
extends FusionModelProvider {
    public CGFusionModelGenerator(DataGenerator generator) {
        super("connectedglass", generator.getPackOutput());
    }

    public void generate() {
        for (CGGlassType type : CGGlassType.values()) {
            this.addModel(new ResourceLocation("connectedglass", type.getRegistryName()), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("block/cube_all"))).texture("all", new ResourceLocation("connectedglass", type.getRegistryName() + "/" + type.getRegistryName()))).build())));
            for (DyeColor color : DyeColor.values()) {
                this.addModel(new ResourceLocation("connectedglass", type.getRegistryName(color)), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("block/cube_all"))).texture("all", new ResourceLocation("connectedglass", type.getRegistryName() + "/" + type.getRegistryName(color)))).build())));
            }
        }
        for (CGGlassType type : CGGlassType.values()) {
            if (!type.hasPanes) continue;
            this.createPaneModels(type.getPaneRegistryName(), type.getRegistryName() + "/" + type.getRegistryName(), type.getPane());
            for (DyeColor color : DyeColor.values()) {
                this.createPaneModels(type.getPaneRegistryName(color), type.getRegistryName() + "/" + type.getRegistryName(color), type.getPane(color));
            }
        }
    }

    private void createPaneModels(String identifier, String texture, CGPaneBlock block) {
        this.addModel(new ResourceLocation("connectedglass", identifier + "_post"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("connectedglass", "block/template_glass_pane_post"))).texture("pane", new ResourceLocation("connectedglass", texture))).texture("edge", new ResourceLocation("connectedglass", texture + "_edge"))).connection(DefaultConnectionPredicates.isSameBlock()).build())));
        ConnectionPredicate notUpOrDown = DefaultConnectionPredicates.isDirection((ConnectionDirection[])((ConnectionDirection[])Arrays.stream(ConnectionDirection.values()).filter(dir -> dir != ConnectionDirection.TOP && dir != ConnectionDirection.BOTTOM).toArray(ConnectionDirection[]::new)));
        this.addModel(new ResourceLocation("connectedglass", identifier + "_side_north"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("connectedglass", "block/template_glass_pane_side"))).texture("pane", new ResourceLocation("connectedglass", texture))).texture("edge", new ResourceLocation("connectedglass", texture + "_edge"))).connection(DefaultConnectionPredicates.matchState((Block)block, (Pair[])new Pair[]{Pair.of((Object)CGPaneBlock.f_52309_, (Object)true)}).or(new ConnectionPredicate[]{notUpOrDown})).build())));
        this.addModel(new ResourceLocation("connectedglass", identifier + "_side_east"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("connectedglass", "block/template_glass_pane_side"))).texture("pane", new ResourceLocation("connectedglass", texture))).texture("edge", new ResourceLocation("connectedglass", texture + "_edge"))).connection(DefaultConnectionPredicates.matchState((Block)block, (Pair[])new Pair[]{Pair.of((Object)CGPaneBlock.f_52310_, (Object)true)}).or(new ConnectionPredicate[]{notUpOrDown})).build())));
        this.addModel(new ResourceLocation("connectedglass", identifier + "_side_south"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("connectedglass", "block/template_glass_pane_side_alt"))).texture("pane", new ResourceLocation("connectedglass", texture))).texture("edge", new ResourceLocation("connectedglass", texture + "_edge"))).connection(DefaultConnectionPredicates.matchState((Block)block, (Pair[])new Pair[]{Pair.of((Object)CGPaneBlock.f_52311_, (Object)true)}).or(new ConnectionPredicate[]{notUpOrDown})).build())));
        this.addModel(new ResourceLocation("connectedglass", identifier + "_side_west"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("connectedglass", "block/template_glass_pane_side_alt"))).texture("pane", new ResourceLocation("connectedglass", texture))).texture("edge", new ResourceLocation("connectedglass", texture + "_edge"))).connection(DefaultConnectionPredicates.matchState((Block)block, (Pair[])new Pair[]{Pair.of((Object)CGPaneBlock.f_52312_, (Object)true)}).or(new ConnectionPredicate[]{notUpOrDown})).build())));
        this.addModel(new ResourceLocation("connectedglass", identifier + "_noside"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("connectedglass", "block/template_glass_pane_noside"))).texture("pane", new ResourceLocation("connectedglass", texture))).texture("edge", new ResourceLocation("connectedglass", texture + "_edge"))).connection(DefaultConnectionPredicates.isSameBlock()).build())));
        this.addModel(new ResourceLocation("connectedglass", identifier + "_noside_alt"), ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)((ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelData.builder().parent(new ResourceLocation("connectedglass", "block/template_glass_pane_noside_alt"))).texture("pane", new ResourceLocation("connectedglass", texture))).texture("edge", new ResourceLocation("connectedglass", texture + "_edge"))).connection(DefaultConnectionPredicates.isSameBlock()).build())));
    }
}

