/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.blockentity;

import com.enderio.base.common.block.light.Light;
import com.enderio.base.common.block.light.LightNode;
import com.enderio.base.common.block.light.PoweredLight;
import com.enderio.base.common.blockentity.LightNodeBlockEntity;
import com.enderio.base.common.init.EIOBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class PoweredLightBlockEntity
extends BlockEntity {
    private static final int RF_USE_TICK = 1;
    private static final int SPREAD = 2;
    private boolean update = true;
    private boolean active = false;

    public PoweredLightBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PoweredLightBlockEntity e) {
        if (((PoweredLight)state.m_60734_()).isWireless()) {
            PoweredLightBlockEntity.consumePowerWireless(level, pos, state, e);
        } else {
            PoweredLightBlockEntity.consumePower(level, pos, state, e);
        }
        if (e.update && e.active) {
            PoweredLightBlockEntity.createNodes(level, pos, state);
            e.update = false;
        }
    }

    public void needsUpdate() {
        this.update = true;
    }

    public boolean isActive() {
        return this.active;
    }

    private static void createNodes(Level level, BlockPos center, BlockState state) {
        ArrayList<BlockPos> start = new ArrayList<BlockPos>();
        ArrayList<BlockPos> prev = new ArrayList<BlockPos>();
        ArrayList<BlockPos> blocked = new ArrayList<BlockPos>();
        start.add(center);
        while (!start.isEmpty()) {
            HashSet<BlockPos> next = new HashSet<BlockPos>();
            for (BlockPos blockPos : start) {
                next.addAll(PoweredLightBlockEntity.spreadNode(level, blockPos, center, blocked, prev));
            }
            prev = new ArrayList(start);
            start = new ArrayList(next);
        }
    }

    private static List<BlockPos> spreadNode(Level level, BlockPos node, BlockPos center, List<BlockPos> blocked, ArrayList<BlockPos> prev) {
        ArrayList<BlockPos> next = new ArrayList<BlockPos>();
        for (Direction dir : Direction.values()) {
            BlockPos relative = node.m_121945_(dir);
            if (prev.contains(relative) || !PoweredLightBlockEntity.inSpreadZone(relative, center)) continue;
            next.add(relative);
            if (level.m_8055_(relative).m_60795_()) {
                level.m_7731_(relative, ((LightNode)((Object)EIOBlocks.LIGHT_NODE.get())).m_49966_(), 3);
                BlockEntity blockEntity = level.m_7702_(relative);
                if (blockEntity instanceof LightNodeBlockEntity) {
                    LightNodeBlockEntity light = (LightNodeBlockEntity)blockEntity;
                    light.setMaster((PoweredLightBlockEntity)level.m_7702_(center));
                }
            }
            boolean bl = false;
            for (BlockPos blockedpos : blocked) {
                if (!PoweredLightBlockEntity.isBlocked(relative, center, blockedpos) || !level.m_8055_(relative).m_60713_((Block)EIOBlocks.LIGHT_NODE.get())) continue;
                level.m_7731_(relative, Blocks.f_50016_.m_49966_(), 3);
                bl = true;
            }
            if (level.m_8055_(relative).m_60795_() || level.m_8055_(relative).m_60713_((Block)EIOBlocks.LIGHT_NODE.get()) || bl) continue;
            blocked.add(relative);
        }
        return next;
    }

    private static boolean isBlocked(BlockPos node, BlockPos center, BlockPos blocked) {
        boolean x = false;
        boolean y = false;
        boolean z = false;
        if (center.m_123341_() >= blocked.m_123341_() && blocked.m_123341_() >= node.m_123341_()) {
            x = true;
        }
        if (center.m_123341_() <= blocked.m_123341_() && blocked.m_123341_() <= node.m_123341_()) {
            x = true;
        }
        if (center.m_123342_() >= blocked.m_123342_() && blocked.m_123342_() >= node.m_123342_()) {
            y = true;
        }
        if (center.m_123342_() <= blocked.m_123342_() && blocked.m_123342_() <= node.m_123342_()) {
            y = true;
        }
        if (center.m_123343_() >= blocked.m_123343_() && blocked.m_123343_() >= node.m_123343_()) {
            z = true;
        }
        if (center.m_123343_() <= blocked.m_123343_() && blocked.m_123343_() <= node.m_123343_()) {
            z = true;
        }
        return x && y && z;
    }

    public static boolean inSpreadZone(BlockPos node, BlockPos center) {
        if (Math.abs(node.m_123341_() - center.m_123341_()) > 2) {
            return false;
        }
        if (Math.abs(node.m_123342_() - center.m_123342_()) > 2) {
            return false;
        }
        return Math.abs(node.m_123343_() - center.m_123343_()) <= 2;
    }

    private static void consumePower(Level level, BlockPos pos, BlockState state, PoweredLightBlockEntity e) {
        LazyOptional energy;
        BlockEntity be = level.m_7702_(pos.m_121945_(((Direction)state.m_61143_((Property)Light.f_54117_)).m_122424_()));
        if (be != null && (energy = be.getCapability(ForgeCapabilities.ENERGY, (Direction)state.m_61143_((Property)Light.f_54117_))).isPresent() && ((IEnergyStorage)energy.resolve().get()).extractEnergy(1, true) == 1) {
            boolean powered = level.m_276867_(pos);
            if (powered == ((Light)state.m_60734_()).isInverted() ? (Boolean)state.m_61143_((Property)Light.ENABLED) != false : (Boolean)state.m_61143_((Property)Light.ENABLED) == false) {
                e.active = false;
                return;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)Light.ENABLED, (Comparable)Boolean.valueOf(false)), 3);
            e.active = true;
            ((IEnergyStorage)energy.resolve().get()).extractEnergy(1, false);
        }
    }

    private static void consumePowerWireless(Level level, BlockPos pos, BlockState state, PoweredLightBlockEntity e) {
        boolean powered = level.m_276867_(pos);
        if (powered != ((Light)state.m_60734_()).isInverted() ? (Boolean)state.m_61143_((Property)Light.ENABLED) != false : (Boolean)state.m_61143_((Property)Light.ENABLED) == false) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)Light.ENABLED, (Comparable)Boolean.valueOf(false)), 3);
            e.active = true;
        }
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128379_("Active", this.active);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.active = tag.m_128471_("Active");
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

