/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.integrations.jei;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.integrations.jei.EnderIOJEIRecipes;
import com.enderio.base.common.integrations.jei.FilterGhostIngredientHandler;
import com.enderio.base.common.integrations.jei.category.FireCraftingCategory;
import com.enderio.base.common.integrations.jei.extension.ShapedEntityStorageCategoryExtension;
import com.enderio.base.common.integrations.jei.subtype.EntityStorageSubtypeInterpreter;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.recipe.ShapedEntityStorageRecipe;
import com.enderio.core.client.gui.screen.EIOScreen;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

@JeiPlugin
public class EnderIOJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return EnderIO.loc("base");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FireCraftingCategory(guiHelper)});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(ShapedEntityStorageRecipe.class, r -> ShapedEntityStorageRecipe.REGISTERED_RECIPES.contains(r.m_6423_()), ShapedEntityStorageCategoryExtension::new);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        EnderIOJEIRecipes recipes = new EnderIOJEIRecipes();
        registration.addRecipes(FireCraftingCategory.TYPE, recipes.getAllFireCraftingRecipes());
        registration.addIngredientInfo((Object)EIOItems.GRAINS_OF_INFINITY.asStack(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{EIOLang.JEI_GRAINS_HAND_GRIND});
        registration.addIngredientInfo((Object)EIOItems.POWDERED_COAL.asStack(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{EIOLang.JEI_COAL_HAND_GRIND});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)EIOItems.FILLED_SOUL_VIAL.get(), (IIngredientSubtypeInterpreter)new EntityStorageSubtypeInterpreter());
        registration.registerSubtypeInterpreter((Item)EIOItems.BROKEN_SPAWNER.get(), (IIngredientSubtypeInterpreter)new EntityStorageSubtypeInterpreter());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(EIOScreen.class, (IGhostIngredientHandler)new FilterGhostIngredientHandler());
    }

    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_8043_(registryAccess);
    }
}

