/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonUtil {
    public static JsonObject serializeItemStackWithoutNBT(ItemStack itemStack) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
        if (itemStack.m_41613_() > 1) {
            jsonobject.addProperty("count", (Number)itemStack.m_41613_());
        }
        return jsonobject;
    }

    public static ItemStack deserializeItemStackWithOldFormat(JsonElement jsonElement, boolean readNBT, boolean disallowsAirInRecipe) {
        ItemStack output;
        if (jsonElement.isJsonObject()) {
            output = CraftingHelper.getItemStack((JsonObject)jsonElement.getAsJsonObject(), (boolean)readNBT, (boolean)disallowsAirInRecipe);
        } else {
            ResourceLocation id = new ResourceLocation(jsonElement.getAsString());
            Item outputItem = (Item)ForgeRegistries.ITEMS.getValue(id);
            output = Objects.requireNonNull(outputItem, "Item must be specified!").m_7968_();
        }
        return output;
    }
}

