/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.gui.widget;

import com.enderio.EnderIO;
import com.enderio.core.client.gui.widgets.EIOWidget;
import com.enderio.machines.common.blockentity.MachineState;
import com.enderio.machines.common.blockentity.MachineStateType;
import com.enderio.machines.common.lang.MachineLang;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ActiveWidget
extends EIOWidget {
    protected static final ResourceLocation WIDGETS = EnderIO.loc("textures/gui/icons/machine_states.png");
    private final Screen displayOn;
    private final Supplier<Set<MachineState>> state;

    public ActiveWidget(Screen displayOn, Supplier<Set<MachineState>> state, int x, int y) {
        super(x, y, 16, 16);
        this.displayOn = displayOn;
        this.state = state;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        MachineState prio = null;
        for (MachineState machineState : this.state.get()) {
            if (prio != null && machineState.type().getPriority() <= prio.type().getPriority()) continue;
            prio = machineState;
        }
        guiGraphics.m_280398_(WIDGETS, this.x, this.y, 0, prio == null ? 16.0f : (float)(prio.type().getPriority() * 16), 0.0f, this.width, this.height, 64, 16);
        RenderSystem.disableDepthTest();
        this.renderToolTip(guiGraphics, mouseX, mouseY);
    }

    private void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY)) {
            List<Component> list = this.state.get().stream().filter(s -> this.state.get().size() <= 1 || s.type() != MachineStateType.ACTIVE).map(s -> s.component()).toList();
            if (list.isEmpty()) {
                list = List.of(MachineLang.TOOLTIP_IDLE);
            }
            guiGraphics.m_280677_(this.displayOn.getMinecraft().f_91062_, list, Optional.empty(), mouseX, mouseY);
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }
}

