/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.task;

import com.enderio.machines.common.blockentity.PoweredSpawnerBlockEntity;
import com.enderio.machines.common.blockentity.task.IPoweredMachineTask;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import com.enderio.machines.common.souldata.SpawnerSoul;
import com.enderio.machines.common.tag.MachineTags;
import com.mojang.serialization.DataResult;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class SpawnerMachineTask
implements IPoweredMachineTask {
    private boolean complete;
    private int energyCost;
    private int energyConsumed = 0;
    private float efficiency = 1.0f;
    private SpawnType spawnType;
    @Nullable
    private EntityType<? extends Entity> entityType;
    private static boolean reload = false;
    private boolean reloadCache;
    private final PoweredSpawnerBlockEntity blockEntity;
    private final IMachineEnergyStorage energyStorage;
    private static final String KEY_ENERGY_CONSUMED = "EnergyConsumed";

    public SpawnerMachineTask(PoweredSpawnerBlockEntity blockEntity, IMachineEnergyStorage energyStorage, Optional<ResourceLocation> rl) {
        this.spawnType = (SpawnType)((Object)MachinesConfig.COMMON.SPAWN_TYPE.get());
        this.reloadCache = reload;
        this.blockEntity = blockEntity;
        this.energyStorage = energyStorage;
        this.loadSoulData(rl);
    }

    @Override
    public IMachineEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public void tick() {
        if (this.entityType == null) {
            if (reload != this.reloadCache) {
                this.reloadCache = reload;
                this.complete = true;
            }
            return;
        }
        if (this.energyConsumed >= this.energyCost) {
            if (this.isAreaClear()) {
                this.complete = this.trySpawnEntity(this.blockEntity.m_58899_(), (ServerLevel)this.blockEntity.m_58904_());
            }
        } else {
            this.energyConsumed += this.energyStorage.consumeEnergy(this.energyCost - this.energyConsumed, false);
        }
    }

    @Override
    public float getProgress() {
        return (float)this.energyConsumed / (float)this.energyCost;
    }

    @Override
    public boolean isCompleted() {
        return this.complete;
    }

    public boolean isAreaClear() {
        AABB range = new AABB(this.blockEntity.m_58899_()).m_82400_((double)this.blockEntity.getRange());
        Optional<ResourceLocation> rl = this.blockEntity.getEntityType();
        if (rl.isEmpty()) {
            this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.UNKNOWN_MOB);
            return false;
        }
        EntityType entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl.get());
        if (entity == null || !ForgeRegistries.ENTITY_TYPES.getKey((Object)entity).equals((Object)rl.get())) {
            this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.UNKNOWN_MOB);
            return false;
        }
        List entities = this.blockEntity.m_58904_().m_142425_((EntityTypeTest)entity, range, p -> p instanceof LivingEntity);
        if (entities.size() >= (Integer)MachinesConfig.COMMON.MAX_SPAWNER_ENTITIES.get()) {
            this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.TOO_MANY_MOB);
            return false;
        }
        long count = BlockPos.m_121921_((AABB)range).filter(pos -> this.blockEntity.m_58904_().m_7702_(pos) instanceof PoweredSpawnerBlockEntity).count();
        if (count >= (long)((Integer)MachinesConfig.COMMON.MAX_SPAWNERS.get()).intValue()) {
            this.efficiency = (float)((Integer)MachinesConfig.COMMON.MAX_SPAWNERS.get()).intValue() / (float)count;
        }
        return true;
    }

    private void loadSoulData(Optional<ResourceLocation> rl) {
        if (rl.isEmpty()) {
            this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.UNKNOWN_MOB);
            return;
        }
        Optional optionalEntity = ForgeRegistries.ENTITY_TYPES.getDelegate(rl.get());
        if (optionalEntity.isEmpty() || !ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)((Holder.Reference)optionalEntity.get()).get())).equals((Object)rl.get())) {
            this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.UNKNOWN_MOB);
            return;
        }
        if (((EntityType)((Holder.Reference)optionalEntity.get()).get()).m_204039_(MachineTags.EntityTypes.SPAWNER_BLACKLIST)) {
            this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.DISABLED);
            return;
        }
        Optional<SpawnerSoul.SoulData> opData = SpawnerSoul.SPAWNER.matches(rl.get());
        if (opData.isEmpty()) {
            this.entityType = (EntityType)((Holder.Reference)optionalEntity.get()).get();
            this.energyCost = 50000;
            Entity entity = this.entityType.m_20615_(this.blockEntity.m_58904_());
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                this.energyCost = (int)((float)this.energyCost + entity2.m_21233_() * 50.0f);
            }
            return;
        }
        SpawnerSoul.SoulData data = opData.get();
        this.entityType = (EntityType)((Holder.Reference)optionalEntity.get()).get();
        this.energyCost = data.power();
        this.spawnType = data.spawnType();
    }

    public boolean trySpawnEntity(BlockPos pos, ServerLevel level) {
        boolean spawned = false;
        if (this.efficiency < level.f_46441_.m_188501_()) {
            this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.TOO_MANY_SPAWNER);
            return false;
        }
        for (int i = 0; i < (Integer)MachinesConfig.COMMON.SPAWN_AMOUNT.get(); ++i) {
            Mob mob;
            RandomSource randomsource = level.m_213780_();
            double x = (double)pos.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.blockEntity.getRange() + 0.5;
            double y = pos.m_123342_() + randomsource.m_188503_(3) - 1;
            double z = (double)pos.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.blockEntity.getRange() + 0.5;
            Optional<ResourceLocation> rl = this.blockEntity.getEntityType();
            if (rl.isEmpty()) {
                this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.UNKNOWN_MOB);
                return false;
            }
            EntityType optionalEntity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl.get());
            if (optionalEntity == null || !ForgeRegistries.ENTITY_TYPES.getKey((Object)optionalEntity).equals((Object)rl.get())) {
                this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.UNKNOWN_MOB);
                return false;
            }
            if (!level.m_45772_(optionalEntity.m_20585_(x, y, z))) continue;
            Entity entity = null;
            switch (this.spawnType) {
                case COPY: {
                    entity = EntityType.m_20645_((CompoundTag)this.blockEntity.getEntityData().getEntityTag(), (Level)level, entity1 -> {
                        entity1.m_7678_(x, y, z, entity1.m_146908_(), entity1.m_146909_());
                        return entity1;
                    });
                    break;
                }
                case ENTITYTYPE: {
                    EntityType id = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(this.blockEntity.getEntityData().getEntityTag().m_128461_("id")));
                    if (id == null) break;
                    entity = id.m_20615_((Level)level);
                    entity.m_6027_(x, y, z);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.spawnType));
                }
            }
            if (entity == null) {
                this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.UNKNOWN_MOB);
                break;
            }
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                MobSpawnEvent.FinalizeSpawn event = ForgeEventFactory.onFinalizeSpawnSpawner((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.m_6436_(pos), null, (CompoundTag)this.blockEntity.getEntityData().getEntityTag(), null);
                if (event == null || event.isSpawnCancelled()) {
                    this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.OTHER_MOD);
                    continue;
                }
                ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)event.getDifficulty(), (MobSpawnType)event.getSpawnType(), (SpawnGroupData)event.getSpawnData(), (CompoundTag)event.getSpawnTag());
            }
            if (!level.m_8860_(entity)) {
                this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.OTHER_MOD);
                continue;
            }
            level.m_46796_(2004, pos, 0);
            level.m_142346_(entity, GameEvent.f_157810_, new BlockPos((int)x, (int)y, (int)z));
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                mob.m_21373_();
            }
            spawned = true;
            this.blockEntity.setReason(PoweredSpawnerBlockEntity.SpawnerBlockedReason.NONE);
        }
        if (spawned) {
            this.energyConsumed -= this.energyCost;
        }
        return spawned;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(KEY_ENERGY_CONSUMED, this.energyConsumed);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.energyConsumed = nbt.m_128451_(KEY_ENERGY_CONSUMED);
    }

    @SubscribeEvent
    static void reloadTags(TagsUpdatedEvent event) {
        reload = !reload;
    }

    public static enum SpawnType {
        ENTITYTYPE("entitytype"),
        COPY("copy");

        private final String name;

        private SpawnType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static DataResult<SpawnType> byName(String pTranslationKey) {
            for (SpawnType type : SpawnType.values()) {
                if (!type.name.equals(pTranslationKey)) continue;
                return DataResult.success((Object)((Object)type));
            }
            return DataResult.error(() -> "unkown type");
        }
    }
}

