/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.config.common;

import com.enderio.machines.common.blockentity.task.SpawnerMachineTask;
import com.enderio.machines.common.config.common.EnergyConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class MachinesCommonConfig {
    public final EnergyConfig ENERGY;
    public final ForgeConfigSpec.ConfigValue<Double> ENCHANTER_LAPIS_COST_FACTOR;
    public final ForgeConfigSpec.ConfigValue<Double> ENCHANTER_LEVEL_COST_FACTOR;
    public final ForgeConfigSpec.ConfigValue<Integer> ENCHANTER_BASE_LEVEL_COST;
    public final ForgeConfigSpec.ConfigValue<Integer> MAX_SPAWNER_ENTITIES;
    public final ForgeConfigSpec.ConfigValue<Integer> MAX_SPAWNERS;
    public final ForgeConfigSpec.ConfigValue<SpawnerMachineTask.SpawnType> SPAWN_TYPE;
    public final ForgeConfigSpec.IntValue SPAWN_AMOUNT;

    public MachinesCommonConfig(ForgeConfigSpec.Builder builder) {
        this.ENERGY = new EnergyConfig(builder);
        builder.push("enchanter");
        this.ENCHANTER_LAPIS_COST_FACTOR = builder.comment("The lapis cost is enchant level multiplied by this value.").define("lapisCostFactor", (Object)3.0);
        this.ENCHANTER_LEVEL_COST_FACTOR = builder.comment("The final XP cost for an enchantment is multiplied by this value. To halve costs set to 0.5, to double them set it to 2.").define("levelCostFactor", (Object)0.75);
        this.ENCHANTER_BASE_LEVEL_COST = builder.comment("Base level cost added to all recipes in the enchanter.").define("baseLevelCost", (Object)2);
        builder.pop();
        builder.push("poweredSpawner");
        this.SPAWN_AMOUNT = builder.comment("The amount of mobs that spawn from the spawner").defineInRange("spawn_amount", 4, 0, Integer.MAX_VALUE);
        this.MAX_SPAWNER_ENTITIES = builder.comment("The amount of entities that will turn off powered spawner if in range.").defineInRange("maxentities", 2, 0, Integer.MAX_VALUE);
        this.SPAWN_TYPE = builder.comment("The way a powered spawner spawns an entity. Possible options: 'ENTITYPE' Spawns the same entity types as the soul vial. 'COPY' Spawns an exact copy of the mob in the soul vial").defineEnum("Spawn Type", (Enum)SpawnerMachineTask.SpawnType.ENTITYTYPE);
        this.MAX_SPAWNERS = builder.comment("The maximum amount of spawners before the spawners suffers a loss of efficiency").defineInRange("maxspawners", 10, 0, Integer.MAX_VALUE);
        builder.pop();
    }
}

