/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.blocks;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LeafCropBlock
extends CroptopiaCropBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final IntegerProperty DISTANCE = BlockStateProperties.f_61414_;

    public LeafCropBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this);
    }

    @Override
    protected boolean m_6266_(BlockState floor, BlockGetter world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        int distance = LeafCropBlock.getDistanceFromLog(neighborState) + 1;
        if (distance != 1 || (Integer)state.m_61143_((Property)DISTANCE) != distance) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (CroptopiaMod.getInstance().platform().skipHarvest()) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        if (this.m_52305_(state) == this.m_7419_()) {
            if (player instanceof ServerPlayer) {
                CroptopiaMod.getInstance().platform().afterBlockBroken(world, player, pos, state, null);
            }
            player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
            player.m_36399_(0.005f);
            world.m_7731_(pos, this.m_52289_(0), 2);
            world.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            if (world instanceof ServerLevel) {
                for (ItemStack droppedStack : LeafCropBlock.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null)) {
                    LeafCropBlock.m_152435_((Level)world, (BlockPos)pos, (Direction)hit.m_82434_(), (ItemStack)droppedStack);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int m_7419_() {
        return 3;
    }

    @Override
    public IntegerProperty m_7959_() {
        return AGE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, DISTANCE});
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i;
        if (world.m_45524_(pos, 0) >= 9 && (i = this.m_52305_(state)) < this.m_7419_() && random.m_188503_(100) % 20 == 0) {
            world.m_7731_(pos, this.m_52289_(i + 1), 2);
        }
        if ((Integer)state.m_61143_((Property)DISTANCE) == 7) {
            LeafCropBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
            world.m_7471_(pos, false);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.m_7731_(pos, LeafCropBlock.updateDistanceFromLogs(state, (LevelAccessor)world, pos), 3);
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    private static BlockState updateDistanceFromLogs(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction[] directions;
        int distance = 7;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : directions = Direction.values()) {
            mutablePos.m_122159_((Vec3i)pos, direction);
            distance = Math.min(distance, LeafCropBlock.getDistanceFromLog(world.m_8055_((BlockPos)mutablePos)) + 1);
            if (distance == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    private static int getDistanceFromLog(BlockState state) {
        if (state.m_204336_(BlockTags.f_13106_)) {
            return 0;
        }
        return state.m_60734_() instanceof LeafCropBlock || state.m_60734_() instanceof LeavesBlock ? (Integer)state.m_61143_((Property)DISTANCE) : 7;
    }
}

