/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.config;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.epherolib.libs.org.spongepowered.configurate.ConfigurationNode;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.SerializationException;
import com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class TreeConfiguration {
    private Set<ResourceKey<Biome>> treesAllowedInBiome;
    private ResourceKey<PlacedFeature> featureKey;

    public TreeConfiguration(ResourceKey<PlacedFeature> featureKey, Collection<ResourceKey<Biome>> treesAllowedInBiome) {
        this.featureKey = featureKey;
        this.treesAllowedInBiome = Set.copyOf(treesAllowedInBiome);
    }

    public static void createSameTreeConfigs(SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>> map, Collection<ResourceKey<Biome>> biomes, ResourceKey<PlacedFeature> ... keys) {
        for (ResourceKey<PlacedFeature> key : keys) {
            map.putAll(key, biomes);
        }
    }

    public ResourceKey<PlacedFeature> getFeatureKey() {
        return this.featureKey;
    }

    public Set<ResourceKey<Biome>> getTreesAllowedInBiome() {
        return this.treesAllowedInBiome;
    }

    public static class Serializer
    implements TypeSerializer<TreeConfiguration> {
        public static final Serializer INSTANCE = new Serializer();
        private final String KEY_FEATURE_NAME = "featureName";
        private final String KEY_ACCEPTABLE_BIOMES = "acceptableBiomes";

        public TreeConfiguration deserialize(Type type, ConfigurationNode node) throws SerializationException {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)CroptopiaMod.createIdentifier(node.node(new Object[]{"featureName"}).getString()));
            List ids = node.node(new Object[]{"acceptableBiomes"}).getList(ResourceLocation.class);
            ArrayList<ResourceKey<Biome>> biomeKeys = new ArrayList<ResourceKey<Biome>>();
            if (ids != null) {
                for (ResourceLocation id : ids) {
                    biomeKeys.add((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id));
                }
            }
            return new TreeConfiguration((ResourceKey<PlacedFeature>)key, biomeKeys);
        }

        public void serialize(Type type, TreeConfiguration obj, ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                node.raw(null);
                return;
            }
            node.node(new Object[]{"featureName"}).set(obj.featureKey);
            ArrayList<ResourceLocation> identifiers = new ArrayList<ResourceLocation>();
            for (ResourceKey<Biome> registryKey : obj.treesAllowedInBiome) {
                identifiers.add(registryKey.m_135782_());
            }
            node.node(new Object[]{"acceptableBiomes"}).setList(ResourceLocation.class, identifiers);
        }
    }
}

