/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.digestionvat;

import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionCachedCheck;
import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionCraftingBehaviour;
import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionStorageBehaviour;
import com.klikli_dev.theurgy.content.behaviour.HasCraftingBehaviour;
import com.klikli_dev.theurgy.content.recipe.DigestionRecipe;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DigestionVatBlockEntity
extends BlockEntity
implements HasCraftingBehaviour<RecipeWrapperWithFluid, DigestionRecipe, DigestionCachedCheck> {
    public DigestionCraftingBehaviour craftingBehaviour;
    public DigestionStorageBehaviour storageBehaviour = new DigestionStorageBehaviour(this, () -> this.craftingBehaviour);

    public DigestionVatBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.DIGESTION_VAT.get(), pPos, pBlockState);
        this.craftingBehaviour = new DigestionCraftingBehaviour(this, () -> this.storageBehaviour.inputInventory, () -> this.storageBehaviour.outputInventory, () -> this.storageBehaviour.fluidTank);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNetwork(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.readNetwork(tag);
        }
    }

    public void readNetwork(CompoundTag tag) {
        this.storageBehaviour.readNetwork(tag);
        this.craftingBehaviour.readNetwork(tag);
    }

    public void writeNetwork(CompoundTag tag) {
        this.storageBehaviour.writeNetwork(tag);
        this.craftingBehaviour.writeNetwork(tag);
    }

    public void tickServer() {
        boolean isOpen = (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61446_);
        boolean hasInput = this.hasInput();
        this.craftingBehaviour.tickServer(!isOpen, hasInput);
        if (!this.craftingBehaviour.isProcessing() && !isOpen) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean hasInput() {
        for (int i = 0; i < this.storageBehaviour.inputInventory.getSlots(); ++i) {
            if (this.storageBehaviour.inputInventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> storage = this.storageBehaviour.getCapability(cap, side);
        if (storage.isPresent()) {
            return storage;
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.storageBehaviour.invalidateCaps();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        this.storageBehaviour.saveAdditional(pTag);
        this.craftingBehaviour.saveAdditional(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.storageBehaviour.load(pTag);
        this.craftingBehaviour.load(pTag);
    }

    public DigestionCraftingBehaviour craftingBehaviour() {
        return this.craftingBehaviour;
    }
}

